/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ModifierChangeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ModifierCorrectionSubProcessor {
    private static final String ADD_SUPPRESSWARNINGS_ID = "org.eclipse.jdt.ui.correction.addSuppressWarnings";
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    private static final String KEY_MODIFIER = "modifier";

    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind, int relevance) throws CoreException {
        String name;
        IMethodBinding bindingDecl;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodDecl = (IMethodBinding)binding;
            bindingDecl = methodDecl.getMethodDeclaration();
            typeBinding = methodDecl.getDeclaringClass();
            name = String.valueOf(methodDecl.getName()) + "()";
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding varDecl = (IVariableBinding)binding;
            typeBinding = varDecl.getDeclaringClass();
            name = binding.getName();
            isLocalVar = !varDecl.isField();
            bindingDecl = Bindings.getVariableDeclaration(varDecl);
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            bindingDecl = typeBinding.getTypeDeclaration();
            name = binding.getName();
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding);
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, name);
                    includedModifiers = 8;
                    break;
                }
                case 4: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononstatic_description, name);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertodefault_description, name);
                    excludedModifiers = 2;
                    break;
                }
                case 5: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding.getTypeDeclaration());
            if (targetCU != null) {
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal(label, targetCU, (IBinding)bindingDecl, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            }
        }
        if (kind == 2 && bindingDecl.getKind() == 3 && (selectedNode instanceof SimpleName || selectedNode instanceof FieldAccess && ((FieldAccess)selectedNode).getExpression() instanceof ThisExpression)) {
            UnresolvedElementsSubProcessor.getVariableProposals(context, problem, proposals);
        }
    }

    public static void addChangeOverriddenModfierProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind) throws JavaModelException {
        IMethodBinding defining;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        if (kind == 2 && problem.getProblemId() != 67109274 && (defining = Bindings.findMethodDefininition(method, false)) != null) {
            int excludedModifiers = 7;
            int includedModifiers = JdtFlags.getVisibilityCode((IBinding)defining);
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodvisibility_description, new String[]{ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8, image));
        }
        IMethodBinding overriddenInClass = null;
        while (overriddenInClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            overriddenInClass = Bindings.findMethodInType(curr, method.getName(), method.getParameterTypes());
        }
        if (overriddenInClass != null) {
            IMethodBinding overriddenDecl = overriddenInClass.getMethodDeclaration();
            ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), overriddenDecl.getDeclaringClass());
            if (targetCU != null) {
                String label;
                int includedModifiers;
                int excludedModifiers;
                String methodName = String.valueOf(curr.getName()) + '.' + overriddenInClass.getName();
                switch (kind) {
                    case 2: {
                        excludedModifiers = 7;
                        includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changeoverriddenvisibility_description, new String[]{methodName, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                        break;
                    }
                    case 5: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononfinal_description, methodName);
                        excludedModifiers = 16;
                        includedModifiers = 0;
                        break;
                    }
                    case 4: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                        excludedModifiers = 8;
                        includedModifiers = 0;
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)"not supported");
                        return;
                    }
                }
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCompletionProposal(label, targetCU, (IBinding)overriddenDecl, selectedNode, includedModifiers, excludedModifiers, 7, image));
            }
        }
    }

    public static void addNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = Bindings.getVariableDeclaration((IVariableBinding)binding);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addRemoveInvalidModfiersProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            selectedNode = ((MethodDeclaration)selectedNode).getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            String methodName = binding.getName();
            int problemId = problem.getProblemId();
            String label = problemId == 67109271 || problemId == 67109225 ? Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName) : Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_removeinvalidmodifiers_description, methodName);
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problemId) {
                case 67109225: 
                case 67109271: {
                    excludedModifiers = 8;
                    break;
                }
                case 67109223: {
                    excludedModifiers = -1026;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -1042;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3360;
                    break;
                }
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
        }
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.ModifierCorrectionSubProcessor_default;
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        boolean hasNoBody;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
        }
        boolean bl = hasNoBody = decl.getBody() == null;
        if (problem.getProblemId() == 67109227 || parentIsAbstractClass) {
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
            if (modifierNode != null) {
                rewrite.remove((ASTNode)modifierNode, null);
            }
            if (hasNoBody) {
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expr != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        if (!hasNoBody && problem.getProblemId() == 603979889) {
            ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
            rewrite.remove((ASTNode)decl.getBody(), null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal2);
        }
        if (problem.getProblemId() == 67109227 && parentTypeDecl != null) {
            ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMakeTypeAbstractProposal(cu, parentTypeDecl, 5);
            proposals.add(proposal);
        }
    }

    public static void addNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(256, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block newBody = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
        Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
        if (expr != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_removenative_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
        proposals.add(proposal);
        if (decl.getBody() != null) {
            ASTRewrite rewrite2 = ASTRewrite.create((AST)decl.getAST());
            rewrite2.remove((ASTNode)decl.getBody(), null);
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite2, 5, image2);
            proposals.add(proposal2);
        }
    }

    public static ASTRewriteCorrectionProposal getMakeTypeAbstractProposal(ICompilationUnit cu, TypeDeclaration typeDeclaration, int relevance) {
        AST ast = typeDeclaration.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        rewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, null);
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, typeDeclaration.getName().getIdentifier());
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, KEY_MODIFIER);
        return proposal;
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Type returnType;
        Expression expression;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
        if (!decl.isConstructor() && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType = decl.getReturnType2(), decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_addmissingbody_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 9, image);
        proposals.add(proposal);
        rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, null);
        String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_setmethodabstract_description;
        Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal2 = new LinkedCorrectionProposal(label2, cu, rewrite, 8, image2);
        proposal2.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, KEY_MODIFIER);
        proposals.add(proposal2);
    }

    public static void addNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = Bindings.getVariableDeclaration((IVariableBinding)binding);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, binding.getName());
            proposals.add(new ModifierChangeCompletionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addOverrideAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMissingAnnotationsProposal(context, problem, "Override");
        if (proposal != null) {
            proposal.setDisplayName(CorrectionMessages.ModifierCorrectionSubProcessor_addoverrideannotation);
            proposal.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            proposals.add(proposal);
        }
    }

    public static void addDeprecatedAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ASTRewriteCorrectionProposal proposal = ModifierCorrectionSubProcessor.getMissingAnnotationsProposal(context, problem, "Deprecated");
        if (proposal != null) {
            proposal.setDisplayName(CorrectionMessages.ModifierCorrectionSubProcessor_adddeprecatedannotation);
            proposal.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            proposals.add(proposal);
        }
    }

    private static ASTRewriteCorrectionProposal getMissingAnnotationsProposal(IInvocationContext context, IProblemLocation problem, String annotationName) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        ASTNode declaringNode = null;
        if (selectedNode instanceof MethodDeclaration) {
            declaringNode = selectedNode;
        } else if (selectedNode instanceof SimpleName) {
            StructuralPropertyDescriptor locationInParent = selectedNode.getLocationInParent();
            if (locationInParent == MethodDeclaration.NAME_PROPERTY || locationInParent == TypeDeclaration.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent();
            } else if (locationInParent == VariableDeclarationFragment.NAME_PROPERTY) {
                declaringNode = selectedNode.getParent().getParent();
            }
        }
        if (declaringNode instanceof BodyDeclaration) {
            BodyDeclaration declaration = (BodyDeclaration)declaringNode;
            AST ast = declaration.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            newAnnotation.setTypeName((Name)ast.newSimpleName(annotationName));
            listRewrite.insertFirst((ASTNode)newAnnotation, null);
            return new ASTRewriteCorrectionProposal("", cu, rewrite, 5, null);
        }
        return null;
    }

    public static void installLinkedVisibilityProposals(LinkedCorrectionProposal proposal, ASTRewrite rewrite, List modifiers) {
        Modifier modifier = ModifierCorrectionSubProcessor.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int selected = modifier.getKeyword().toFlagValue();
            proposal.addLinkedPosition(rewrite.track((ASTNode)modifier), false, KEY_MODIFIER);
            proposal.addLinkedPositionProposal(KEY_MODIFIER, new ModifierLinkedModeProposal(selected));
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 4;
            nArray[3] = 2;
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    proposal.addLinkedPositionProposal(KEY_MODIFIER, new ModifierLinkedModeProposal(flagValues[i]));
                }
                ++i;
            }
        }
    }

    private static Modifier findVisibilityModifier(List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Modifier modifier;
            Modifier.ModifierKeyword keyword;
            Object curr = modifiers.get(i);
            if (curr instanceof Modifier && ((keyword = (modifier = (Modifier)curr).getKeyword()) == Modifier.ModifierKeyword.PUBLIC_KEYWORD || keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD || keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD)) {
                return modifier;
            }
            ++i;
        }
        return null;
    }

    public static final boolean hasSuppressWarningsProposal(int problemId) {
        return CorrectionEngine.getWarningToken((int)problemId) != null;
    }

    public static void addSuppressWarningsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        BodyDeclaration target;
        if (problem.isError()) {
            return;
        }
        String warningToken = CorrectionEngine.getWarningToken((int)problem.getProblemId());
        if (warningToken == null) {
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            ASTNode parent = node.getParent();
            if (parent.getLocationInParent() == VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
                ModifierCorrectionSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), parent.getParent(), warningToken, -2, proposals);
                return;
            }
        } else if (node.getLocationInParent() == SingleVariableDeclaration.NAME_PROPERTY) {
            ModifierCorrectionSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), node.getParent(), warningToken, -2, proposals);
            return;
        }
        if ((target = ASTResolving.findParentBodyDeclaration(node)) != null) {
            ModifierCorrectionSubProcessor.addSuppressWarningsProposal(context.getCompilationUnit(), (ASTNode)target, warningToken, -3, proposals);
        }
    }

    private static String getFirstFragmentName(List fragments) {
        if (fragments.size() > 0) {
            return ((VariableDeclarationFragment)fragments.get(0)).getName().getIdentifier();
        }
        return new String();
    }

    private static void addSuppressWarningsProposal(ICompilationUnit cu, ASTNode node, String warningToken, int relevance, Collection proposals) {
        Expression value;
        SingleMemberAnnotation annotation;
        String name;
        ChildListPropertyDescriptor property = null;
        switch (node.getNodeType()) {
            case 44: {
                property = SingleVariableDeclaration.MODIFIERS2_PROPERTY;
                name = ((SingleVariableDeclaration)node).getName().getIdentifier();
                break;
            }
            case 60: {
                property = VariableDeclarationStatement.MODIFIERS2_PROPERTY;
                name = ModifierCorrectionSubProcessor.getFirstFragmentName(((VariableDeclarationStatement)node).fragments());
                break;
            }
            case 55: {
                property = TypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((TypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 81: {
                property = AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
                name = ((AnnotationTypeDeclaration)node).getName().getIdentifier();
                break;
            }
            case 71: {
                property = EnumDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumDeclaration)node).getName().getIdentifier();
                break;
            }
            case 23: {
                property = FieldDeclaration.MODIFIERS2_PROPERTY;
                name = ModifierCorrectionSubProcessor.getFirstFragmentName(((FieldDeclaration)node).fragments());
                break;
            }
            case 28: {
                property = Initializer.MODIFIERS2_PROPERTY;
                name = CorrectionMessages.ModifierCorrectionSubProcessor_suppress_warnings_initializer_label;
                break;
            }
            case 31: {
                property = MethodDeclaration.MODIFIERS2_PROPERTY;
                name = String.valueOf(((MethodDeclaration)node).getName().getIdentifier()) + "()";
                break;
            }
            case 82: {
                property = AnnotationTypeMemberDeclaration.MODIFIERS2_PROPERTY;
                name = String.valueOf(((AnnotationTypeMemberDeclaration)node).getName().getIdentifier()) + "()";
                break;
            }
            case 72: {
                property = EnumConstantDeclaration.MODIFIERS2_PROPERTY;
                name = ((EnumConstantDeclaration)node).getName().getIdentifier();
                break;
            }
            default: {
                JavaPlugin.logErrorMessage("SuppressWarning quick fix: wrong node kind: " + node.getNodeType());
                return;
            }
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        StringLiteral newStringLiteral = ast.newStringLiteral();
        newStringLiteral.setLiteralValue(warningToken);
        Annotation existing = ModifierCorrectionSubProcessor.findExistingAnnotation((List)node.getStructuralProperty((StructuralPropertyDescriptor)property));
        if (existing == null) {
            ListRewrite listRewrite = rewrite.getListRewrite(node, property);
            SingleMemberAnnotation newAnnot = ast.newSingleMemberAnnotation();
            newAnnot.setTypeName((Name)ast.newSimpleName("SuppressWarnings"));
            newAnnot.setValue((Expression)newStringLiteral);
            listRewrite.insertFirst((ASTNode)newAnnot, null);
        } else if (existing instanceof SingleMemberAnnotation) {
            annotation = (SingleMemberAnnotation)existing;
            value = annotation.getValue();
            if (!ModifierCorrectionSubProcessor.addSuppressArgument(rewrite, value, newStringLiteral)) {
                rewrite.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)newStringLiteral, null);
            }
        } else if (existing instanceof NormalAnnotation && !ModifierCorrectionSubProcessor.addSuppressArgument(rewrite, value = ModifierCorrectionSubProcessor.findValue((annotation = (NormalAnnotation)existing).values()), newStringLiteral)) {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
            MemberValuePair pair = ast.newMemberValuePair();
            pair.setName(ast.newSimpleName("value"));
            pair.setValue((Expression)newStringLiteral);
            listRewrite.insertFirst((ASTNode)pair, null);
        }
        String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_suppress_warnings_label, new String[]{warningToken, name});
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.annotation_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance, image);
        proposal.setCommandId(ADD_SUPPRESSWARNINGS_ID);
        proposals.add(proposal);
    }

    private static boolean addSuppressArgument(ASTRewrite rewrite, Expression value, StringLiteral newStringLiteral) {
        if (value instanceof ArrayInitializer) {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)value, ArrayInitializer.EXPRESSIONS_PROPERTY);
            listRewrite.insertLast((ASTNode)newStringLiteral, null);
        } else if (value instanceof StringLiteral) {
            ArrayInitializer newArr = rewrite.getAST().newArrayInitializer();
            newArr.expressions().add(rewrite.createMoveTarget((ASTNode)value));
            newArr.expressions().add(newStringLiteral);
            rewrite.replace((ASTNode)value, (ASTNode)newArr, null);
        } else {
            return false;
        }
        return true;
    }

    private static Expression findValue(List keyValues) {
        int i = 0;
        int len = keyValues.size();
        while (i < len) {
            MemberValuePair curr = (MemberValuePair)keyValues.get(i);
            if ("value".equals(curr.getName().getIdentifier())) {
                return curr.getValue();
            }
            ++i;
        }
        return null;
    }

    private static Annotation findExistingAnnotation(List modifiers) {
        int i = 0;
        int len = modifiers.size();
        while (i < len) {
            Annotation annotation;
            String fullyQualifiedName;
            Object curr = modifiers.get(i);
            if ((curr instanceof NormalAnnotation || curr instanceof SingleMemberAnnotation) && ("SuppressWarnings".equals(fullyQualifiedName = (annotation = (Annotation)curr).getTypeName().getFullyQualifiedName()) || "java.lang.SuppressWarnings".equals(fullyQualifiedName))) {
                return annotation;
            }
            ++i;
        }
        return null;
    }

    private static class ModifierLinkedModeProposal
    implements LinkedCorrectionProposal.ILinkedModeProposal,
    ICompletionProposalExtension2 {
        private LinkedPositionGroup fLinkedPositionGroup;
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier) {
            this.fModifier = modifier;
        }

        public void setLinkedPositionGroup(LinkedPositionGroup group) {
            this.fLinkedPositionGroup = group;
        }

        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        public Image getImage() {
            return null;
        }

        private Position getCurrentPosition(int offset) {
            if (this.fLinkedPositionGroup != null) {
                LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
                int i = 0;
                while (i < positions.length) {
                    LinkedPosition position = positions[i];
                    if (position.overlapsWith(offset, 0)) {
                        return position;
                    }
                    ++i;
                }
            }
            return null;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            Position currentPosition = this.getCurrentPosition(offset);
            if (currentPosition == null) {
                return;
            }
            try {
                IDocument document = viewer.getDocument();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && Strings.isIndentChar(document.getChar(k))) {
                        ++k;
                    }
                    document.replace(end, k - end, new String());
                    document.replace(currentPosition.offset, currentPosition.length, new String());
                } else {
                    document.replace(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString());
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        document.replace(end, 0, String.valueOf(' '));
                    }
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
        }

        public int getRelevance() {
            return 0;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            return false;
        }
    }
}

