/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSuperTypeRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UseSupertypeWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "UseSupertypeWizard";

    public UseSupertypeWizard(UseSuperTypeRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.UseSupertypeWizard_Use_Super_Type_Where_Possible);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new UseSupertypeInputPage());
    }

    private static class UseSupertypeInputPage
    extends UserInputWizardPage {
        private static final String REWRITE_INSTANCEOF = "rewriteInstanceOf";
        public static final String PAGE_NAME = "UseSupertypeInputPage";
        private TableViewer fTableViewer;
        private final Map fFileCount = new HashMap(2);
        private static final String MESSAGE = RefactoringMessages.UseSupertypeInputPage_Select_supertype;
        private JavaElementLabelProvider fTableLabelProvider;
        private IDialogSettings fSettings;

        public UseSupertypeInputPage() {
            super(PAGE_NAME);
            this.setMessage(MESSAGE);
        }

        private void loadSettings() {
            this.fSettings = this.getDialogSettings().getSection(UseSupertypeWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(UseSupertypeWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(REWRITE_INSTANCEOF, false);
            }
            ((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().setInstanceOf(this.fSettings.getBoolean(REWRITE_INSTANCEOF));
        }

        public void createControl(Composite parent) {
            this.loadSettings();
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            Label label = new Label(composite, 0);
            label.setText(Messages.format(RefactoringMessages.UseSupertypeInputPage_Select_supertype_to_use, JavaElementLabels.getElementLabel((IJavaElement)((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().getSubType(), 262144L)));
            label.setLayoutData((Object)new GridData());
            this.addTableComponent(composite);
            Button checkbox = new Button(composite, 32);
            checkbox.setText(RefactoringMessages.UseSupertypeInputPage_Use_in_instanceof);
            checkbox.setLayoutData((Object)new GridData());
            checkbox.setSelection(((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().isInstanceOf());
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkbox){
                final /* synthetic */ UseSupertypeInputPage this$1;
                private final /* synthetic */ Button val$checkbox;
                {
                    this.this$1 = useSupertypeInputPage;
                    this.val$checkbox = button;
                }

                public void widgetSelected(SelectionEvent e) {
                    ((UseSuperTypeRefactoring)UseSupertypeInputPage.access$0(this.this$1)).getUseSuperTypeProcessor().setInstanceOf(this.val$checkbox.getSelection());
                    UseSupertypeInputPage.access$1(this.this$1).put("rewriteInstanceOf", this.val$checkbox.getSelection());
                    this.this$1.setMessage(UseSupertypeInputPage.access$2());
                    this.this$1.setPageComplete(true);
                    UseSupertypeInputPage.access$3(this.this$1).clear();
                    UseSupertypeInputPage.access$4(this.this$1).refresh();
                }
            });
            Dialog.applyDialogFont((Control)composite);
        }

        private void addTableComponent(Composite composite) {
            this.fTableViewer = new TableViewer(composite, 2820);
            this.fTableViewer.getTable().setLayoutData((Object)new GridData(1808));
            this.fTableLabelProvider = new UseSupertypeLabelProvider(this.fFileCount);
            this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fTableLabelProvider);
            this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ UseSupertypeInputPage this$1;
                {
                    this.this$1 = useSupertypeInputPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                    if (new Integer(0).equals(UseSupertypeInputPage.access$3(this.this$1).get(ss.getFirstElement()))) {
                        this.this$1.setMessage(RefactoringMessages.UseSupertypeInputPage_No_updates, 1);
                        this.this$1.setPageComplete(false);
                    } else {
                        this.this$1.setMessage(UseSupertypeInputPage.access$2());
                        this.this$1.setPageComplete(true);
                    }
                    UseSupertypeInputPage.access$4(this.this$1).refresh();
                }
            });
            this.fTableViewer.setInput((Object)((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().getSuperTypes());
            this.fTableViewer.getTable().setSelection(0);
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            IWizardPage nextPage = super.getNextPage();
            this.updateUpdateLabels();
            return nextPage;
        }

        private void updateUpdateLabels() {
            IType selectedType = this.getSelectedSupertype();
            int count = ((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().getChanges();
            this.fFileCount.put(selectedType, new Integer(count));
            if (count == 0) {
                this.setMessage(RefactoringMessages.UseSupertypeInputPage_No_updates, 1);
                this.setPageComplete(false);
            }
            this.fTableViewer.refresh();
            if (this.noSupertypeCanBeUsed()) {
                this.setMessage(RefactoringMessages.UseSupertypeWizard_10, 1);
                this.setPageComplete(false);
            }
        }

        private boolean noSupertypeCanBeUsed() {
            return this.fTableViewer.getTable().getItemCount() == this.countFilesWithValue(0);
        }

        private int countFilesWithValue(int i) {
            int count = 0;
            Iterator iter = this.fFileCount.keySet().iterator();
            while (iter.hasNext()) {
                if ((Integer)this.fFileCount.get(iter.next()) != i) continue;
                ++count;
            }
            return count;
        }

        private IType getSelectedSupertype() {
            IStructuredSelection ss = (IStructuredSelection)this.fTableViewer.getSelection();
            return (IType)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            boolean superFinish = super.performFinish();
            if (!superFinish) {
                return false;
            }
            int count = ((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().getChanges();
            if (count == 0) {
                this.updateUpdateLabels();
                return false;
            }
            return superFinish;
        }

        private void initializeRefactoring() {
            StructuredSelection ss = (StructuredSelection)this.fTableViewer.getSelection();
            ((UseSuperTypeRefactoring)this.getRefactoring()).getUseSuperTypeProcessor().setSuperType((IType)ss.getFirstElement());
        }

        public void dispose() {
            this.fTableViewer = null;
            this.fFileCount.clear();
            this.fTableLabelProvider = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTableViewer != null) {
                this.fTableViewer.getTable().setFocus();
            }
        }

        static /* synthetic */ Refactoring access$0(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.getRefactoring();
        }

        static /* synthetic */ IDialogSettings access$1(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.fSettings;
        }

        static /* synthetic */ String access$2() {
            return MESSAGE;
        }

        static /* synthetic */ Map access$3(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.fFileCount;
        }

        static /* synthetic */ TableViewer access$4(UseSupertypeInputPage useSupertypeInputPage) {
            return useSupertypeInputPage.fTableViewer;
        }

        private static class UseSupertypeLabelProvider
        extends JavaElementLabelProvider {
            private final Map fFileCount;

            UseSupertypeLabelProvider(Map fileCount) {
                this.fFileCount = fileCount;
            }

            public String getText(Object element) {
                String superText = super.getText(element);
                if (!this.fFileCount.containsKey(element)) {
                    return superText;
                }
                int count = (Integer)this.fFileCount.get(element);
                if (count == 0) {
                    Object[] keys = new String[]{superText};
                    return Messages.format(RefactoringMessages.UseSupertypeInputPage_no_possible_updates, keys);
                }
                if (count == 1) {
                    Object[] keys = new String[]{superText};
                    return Messages.format(RefactoringMessages.UseSupertypeInputPage_updates_possible_in_file, keys);
                }
                Object[] keys = new String[]{superText, String.valueOf(count)};
                return Messages.format(RefactoringMessages.UseSupertypeInputPage_updates_possible_in_files, keys);
            }
        }
    }
}

