/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class FileTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    static /* synthetic */ Class class$0;

    FileTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.isDragable(this.fProvider.getSelection());
    }

    private boolean isDragable(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) continue;
            IJavaElement jElement = (IJavaElement)element;
            int type = jElement.getElementType();
            if (type != 3 && type != 5 && type != 7) {
                return false;
            }
            IPackageFragmentRoot root = (IPackageFragmentRoot)jElement.getAncestor(3);
            if (root == null || !root.isArchive()) continue;
            return false;
        }
        List resources = this.convertIntoResources(selection);
        return resources.size() == selection.size();
    }

    public void dragSetData(DragSourceEvent event) {
        List elements = this.getResources();
        if (elements == null || elements.size() == 0) {
            event.data = null;
            return;
        }
        event.data = FileTransferDragAdapter.getResourceLocations(elements);
    }

    private static String[] getResourceLocations(List resources) {
        return Resources.getLocationOSStrings(resources.toArray(new IResource[resources.size()]));
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail != 2 && (event.detail == 0 || event.detail == 8)) {
            this.handleRefresh(event);
        }
    }

    void handleDropMove(DragSourceEvent event) {
        final List elements = this.getResources();
        if (elements == null || elements.size() == 0) {
            return;
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(PackagesMessages.DragAdapter_deleting, elements.size());
                    MultiStatus status = FileTransferDragAdapter.this.createMultiStatus();
                    Iterator iter = elements.iterator();
                    while (true) {
                        Object var6_6;
                        if (!iter.hasNext()) {
                            if (status.isOK()) break;
                            throw new CoreException((IStatus)status);
                        }
                        IResource resource = (IResource)iter.next();
                        try {
                            try {
                                monitor.subTask(resource.getFullPath().toOSString());
                                resource.delete(true, null);
                            }
                            catch (CoreException e) {
                                status.add(e.getStatus());
                            }
                        }
                        catch (Throwable throwable) {
                            var6_6 = null;
                            monitor.worked(1);
                            throw throwable;
                        }
                        {
                            var6_6 = null;
                        }
                        monitor.worked(1);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                monitor.done();
            }
        };
        this.runOperation((IRunnableWithProgress)op, true, false);
    }

    private void handleRefresh(DragSourceEvent event) {
        final Set roots = this.collectRoots(this.getResources());
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(PackagesMessages.DragAdapter_refreshing, roots.size());
                    MultiStatus status = FileTransferDragAdapter.this.createMultiStatus();
                    Iterator iter = roots.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            if (status.isOK()) break;
                            throw new CoreException((IStatus)status);
                        }
                        IResource r = (IResource)iter.next();
                        try {
                            r.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var6_8 = null;
                }
                monitor.done();
            }
        };
        this.runOperation((IRunnableWithProgress)op, true, false);
    }

    protected Set collectRoots(List elements) {
        HashSet<Object> roots = new HashSet<Object>(10);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IContainer parent = resource.getParent();
            if (parent == null) {
                roots.add(resource);
                continue;
            }
            roots.add(parent);
        }
        return roots;
    }

    private List getResources() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        return this.convertIntoResources((IStructuredSelection)s);
    }

    private List convertIntoResources(IStructuredSelection selection) {
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            IResource r = null;
            if (o instanceof IResource) {
                r = (IResource)o;
            } else if (o instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                r = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    private MultiStatus createMultiStatus() {
        return new MultiStatus(JavaPlugin.getPluginId(), 0, PackagesMessages.DragAdapter_problem, null);
    }

    private void runOperation(IRunnableWithProgress op, boolean fork, boolean cancelable) {
        try {
            Shell parent = JavaPlugin.getActiveWorkbenchShell();
            new ProgressMonitorDialog(parent).run(fork, cancelable, op);
        }
        catch (InvocationTargetException e) {
            String message = PackagesMessages.DragAdapter_problem;
            String title = PackagesMessages.DragAdapter_problemTitle;
            ExceptionHandler.handle(e, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }
}

