/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariable;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class JavaContextType
extends CompilationUnitContextType {
    public static final String NAME = "java";

    public JavaContextType() {
        super(NAME);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new CompilationUnitContextType.File());
        this.addResolver(new CompilationUnitContextType.PrimaryTypeName());
        this.addResolver(new CompilationUnitContextType.ReturnType());
        this.addResolver(new CompilationUnitContextType.Method());
        this.addResolver(new CompilationUnitContextType.Type());
        this.addResolver(new CompilationUnitContextType.Package());
        this.addResolver(new CompilationUnitContextType.Project());
        this.addResolver(new CompilationUnitContextType.Arguments());
        this.addResolver(new Array());
        this.addResolver(new ArrayType());
        this.addResolver(new ArrayElement());
        this.addResolver(new Index());
        this.addResolver(new Iterator());
        this.addResolver(new Collection());
        this.addResolver(new Iterable());
        this.addResolver(new IterableType());
        this.addResolver(new IterableElement());
        this.addResolver(new Todo());
    }

    public CompilationUnitContext createContext(IDocument document, int offset, int length, ICompilationUnit compilationUnit) {
        return new JavaContext(this, document, offset, length, compilationUnit);
    }

    protected static class Array
    extends TemplateVariableResolver {
        public Array() {
            super("array", JavaTemplateMessages.JavaContextType_variable_description_array);
        }

        protected String[] resolveAll(TemplateContext context) {
            return ((JavaContext)context).getArrays();
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                MultiVariable mv = (MultiVariable)variable;
                String[] bindings = this.resolveAll(context);
                if (bindings.length > 0) {
                    mv.setValues(bindings);
                    MultiVariableGuess guess = jc.getMultiVariableGuess();
                    if (guess == null) {
                        guess = new MultiVariableGuess(mv);
                        jc.setMultiVariableGuess(guess);
                    }
                }
                if (bindings.length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class ArrayType
    extends TemplateVariableResolver {
        public ArrayType() {
            super("array_type", JavaTemplateMessages.JavaContextType_variable_description_array_type);
        }

        protected String[] resolveAll(TemplateContext context) {
            String[][] arrayTypes = ((JavaContext)context).getArrayTypes();
            String[] types = new String[arrayTypes.length];
            int i = 0;
            while (i < types.length) {
                types[i] = arrayTypes[i][0];
                ++i;
            }
            return types;
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] arrays = ((JavaContext)context).getArrays();
                String[][] types = ((JavaContext)context).getArrayTypes();
                int i = 0;
                while (i < arrays.length) {
                    mv.setValues(arrays[i], types[i]);
                    ++i;
                }
                if (arrays.length > 1 || types.length == 1 && types[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class ArrayElement
    extends TemplateVariableResolver {
        public ArrayElement() {
            super("array_element", JavaTemplateMessages.JavaContextType_variable_description_array_element);
        }

        protected String[] resolveAll(TemplateContext context) {
            String[][] groupedElements = ((JavaContext)context).getArrayElements();
            String[] elements = new String[groupedElements.length];
            int i = 0;
            while (i < elements.length) {
                elements[i] = groupedElements[i][0];
                ++i;
            }
            return elements;
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] arrays = ((JavaContext)context).getArrays();
                String[][] elems = ((JavaContext)context).getArrayElements();
                int i = 0;
                while (i < arrays.length) {
                    mv.setValues(arrays[i], elems[i]);
                    ++i;
                }
                if (arrays.length > 1 || elems.length == 1 && elems[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class Index
    extends TemplateVariableResolver {
        public Index() {
            super("index", JavaTemplateMessages.JavaContextType_variable_description_index);
        }

        protected String resolve(TemplateContext context) {
            return ((JavaContext)context).getIndex();
        }
    }

    protected static class Collection
    extends TemplateVariableResolver {
        public Collection() {
            super("collection", JavaTemplateMessages.JavaContextType_variable_description_collection);
        }

        protected String[] resolveAll(TemplateContext context) {
            String[] collections = ((JavaContext)context).getCollections();
            if (collections.length > 0) {
                return collections;
            }
            return super.resolveAll(context);
        }
    }

    protected static class Iterable
    extends TemplateVariableResolver {
        public Iterable() {
            super("iterable", JavaTemplateMessages.JavaContextType_variable_description_iterable);
        }

        protected String[] resolveAll(TemplateContext context) {
            String[] iterables = ((JavaContext)context).getIterables();
            if (iterables.length > 0) {
                return iterables;
            }
            return super.resolveAll(context);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                MultiVariable mv = (MultiVariable)variable;
                String[] bindings = this.resolveAll(context);
                if (bindings.length > 0) {
                    mv.setValues(bindings);
                    MultiVariableGuess guess = jc.getMultiVariableGuess();
                    if (guess == null) {
                        guess = new MultiVariableGuess(mv);
                        jc.setMultiVariableGuess(guess);
                    }
                }
                if (bindings.length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class IterableType
    extends TemplateVariableResolver {
        public IterableType() {
            super("iterable_type", JavaTemplateMessages.JavaContextType_variable_description_iterable_type);
        }

        protected String[] resolveAll(TemplateContext context) {
            String[][] iterableTypes = ((JavaContext)context).getIterableTypes();
            String[] types = new String[iterableTypes.length];
            int i = 0;
            while (i < iterableTypes.length) {
                types[i] = iterableTypes[i][0];
                ++i;
            }
            if (types.length > 0) {
                return types;
            }
            return super.resolveAll(context);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] iterables = ((JavaContext)context).getIterables();
                String[][] types = ((JavaContext)context).getIterableTypes();
                int i = 0;
                while (i < iterables.length) {
                    mv.setValues(iterables[i], types[i]);
                    ++i;
                }
                if (iterables.length > 1 || types.length == 1 && types[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class IterableElement
    extends TemplateVariableResolver {
        public IterableElement() {
            super("iterable_element", JavaTemplateMessages.JavaContextType_variable_description_iterable_element);
        }

        protected String[] resolveAll(TemplateContext context) {
            ArrayList<String> result = new ArrayList<String>();
            String[][] groupedElements = ((JavaContext)context).getIterableElements();
            int i = 0;
            while (i < groupedElements.length) {
                String[] names = groupedElements[i];
                int j = 0;
                while (j < names.length) {
                    result.add(names[j]);
                    ++j;
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                MultiVariable mv = (MultiVariable)variable;
                String[] iterables = ((JavaContext)context).getIterables();
                String[][] elems = ((JavaContext)context).getIterableElements();
                int i = 0;
                while (i < iterables.length) {
                    mv.setValues(iterables[i], elems[i]);
                    ++i;
                }
                if (iterables.length > 1 || elems.length == 1 && elems[0].length > 1) {
                    variable.setUnambiguous(false);
                } else {
                    variable.setUnambiguous(this.isUnambiguous(context));
                }
            } else {
                super.resolve(variable, context);
            }
        }
    }

    protected static class Iterator
    extends TemplateVariableResolver {
        public Iterator() {
            super("iterator", JavaTemplateMessages.JavaContextType_variable_description_iterator);
        }

        protected String resolve(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            if (!context.isReadOnly()) {
                javaContext.addIteratorImport();
            }
            return javaContext.getIterator();
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaTemplateMessages.JavaContextType_variable_description_todo);
        }

        protected String resolve(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            ICompilationUnit compilationUnit = javaContext.getCompilationUnit();
            if (compilationUnit == null) {
                return "XXX";
            }
            IJavaProject javaProject = compilationUnit.getJavaProject();
            String todoTaskTag = StubUtility.getTodoTaskTag(javaProject);
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

