/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.TextEditGroup;

public final class MemberVisibilityAdjustor {
    private Map fAdjustments = new HashMap();
    private int fFailureSeverity = 3;
    private boolean fGetters = true;
    private boolean fIncoming = true;
    private boolean fOutgoing = true;
    private final IMember fReferenced;
    private final IJavaElement fReferencing;
    private ASTRewrite fRewrite = null;
    private Map fRewrites = new HashMap(3);
    private CompilationUnit fRoot = null;
    private IJavaSearchScope fScope;
    private boolean fSetters = true;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private final Map fTypeHierarchies = new HashMap();
    private int fVisibilitySeverity = 2;

    public static String getLabel(IJavaElement element) {
        Assert.isNotNull(element);
        return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED | JavaElementLabels.ALL_DEFAULT);
    }

    public static String getLabel(Modifier.ModifierKeyword keyword) {
        Assert.isTrue(MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        if (keyword == null) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default;
        }
        if (Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
        }
        if (Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_private;
    }

    public static String getMessage(IMember member) {
        Assert.isTrue(member instanceof IType || member instanceof IMethod || member instanceof IField);
        if (member instanceof IType) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning;
        }
        if (member instanceof IMethod) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning;
    }

    public static boolean hasLowerVisibility(int modifiers, int threshold) {
        if (Modifier.isPrivate((int)threshold)) {
            return false;
        }
        if (Modifier.isPublic((int)threshold)) {
            return !Modifier.isPublic((int)modifiers);
        }
        if (Modifier.isProtected((int)threshold)) {
            return !Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers);
        }
        return Modifier.isPrivate((int)modifiers);
    }

    private static boolean hasLowerVisibility(Modifier.ModifierKeyword keyword, Modifier.ModifierKeyword threshold) {
        Assert.isTrue(MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        Assert.isTrue(MemberVisibilityAdjustor.isVisibilityKeyword(threshold));
        return MemberVisibilityAdjustor.hasLowerVisibility(keyword != null ? keyword.toFlagValue() : 0, threshold != null ? threshold.toFlagValue() : 0);
    }

    private static boolean isStatusSeverity(int severity) {
        return severity == 3 || severity == 4 || severity == 1 || severity == 0 || severity == 2;
    }

    private static boolean isVisibilityKeyword(Modifier.ModifierKeyword keyword) {
        return keyword == null || Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PRIVATE_KEYWORD.equals(keyword);
    }

    private static boolean isVisibilityModifier(int modifier) {
        return modifier == 0 || modifier == 1 || modifier == 4 || modifier == 2;
    }

    private static int keywordToVisibility(Modifier.ModifierKeyword keyword) {
        int visibility = 0;
        if (keyword == Modifier.ModifierKeyword.PUBLIC_KEYWORD) {
            visibility = 1;
        } else if (keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD) {
            visibility = 2;
        } else if (keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD) {
            visibility = 4;
        }
        return visibility;
    }

    public static boolean needsVisibilityAdjustments(IMember member, int threshold, Map adjustments) {
        Assert.isNotNull(member);
        Assert.isTrue(MemberVisibilityAdjustor.isVisibilityModifier(threshold));
        Assert.isNotNull(adjustments);
        IncomingMemberVisibilityAdjustment adjustment = (IncomingMemberVisibilityAdjustment)adjustments.get(member);
        if (adjustment != null) {
            Modifier.ModifierKeyword keyword = adjustment.getKeyword();
            return MemberVisibilityAdjustor.hasLowerVisibility(keyword == null ? 0 : keyword.toFlagValue(), threshold);
        }
        return true;
    }

    public static boolean needsVisibilityAdjustments(IMember member, Modifier.ModifierKeyword threshold, Map adjustments) {
        Assert.isNotNull(member);
        Assert.isNotNull(adjustments);
        IncomingMemberVisibilityAdjustment adjustment = (IncomingMemberVisibilityAdjustment)adjustments.get(member);
        if (adjustment != null) {
            return MemberVisibilityAdjustor.hasLowerVisibility(adjustment.getKeyword(), threshold);
        }
        return true;
    }

    public MemberVisibilityAdjustor(IJavaElement referencing, IMember referenced) {
        Assert.isTrue(!(referenced instanceof IInitializer));
        Assert.isTrue(referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment);
        this.fScope = RefactoringScopeFactory.createReferencedScope(new IJavaElement[]{referenced}, 11);
        this.fReferencing = referencing;
        this.fReferenced = referenced;
    }

    private void adjustIncomingVisibility(IMember member, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword threshold = this.computeIncomingVisibilityThreshold(member, this.fReferenced, monitor);
        if (MemberVisibilityAdjustor.hasLowerVisibility(this.fReferenced.getFlags(), threshold == null ? 0 : threshold.toFlagValue()) && this.needsVisibilityAdjustment(this.fReferenced, threshold)) {
            this.fAdjustments.put(this.fReferenced, new IncomingMemberVisibilityAdjustment(this.fReferenced, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(MemberVisibilityAdjustor.getMessage(this.fReferenced), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)this.fReferenced), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(this.fReferenced), null, (int)-1, null)));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustIncomingVisibility(IType[] types, IMethod[] methods, IField[] fields, IProgressMonitor monitor) throws JavaModelException {
        try {
            int index;
            IType type;
            monitor.beginTask("", fields.length + methods.length + types.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            IField field = null;
            int index2 = 0;
            while (true) {
                if (index2 >= fields.length) break;
                field = fields[index2];
                if (!field.isBinary() && !field.isReadOnly()) {
                    this.adjustIncomingVisibility((IMember)field, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++index2;
            }
            IMethod method = null;
            int index3 = 0;
            while (true) {
                if (index3 >= methods.length) {
                    type = null;
                    index = 0;
                    break;
                }
                method = methods[index3];
                if (!(method.isBinary() || method.isReadOnly() || method.isMainMethod())) {
                    this.adjustIncomingVisibility((IMember)method, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++index3;
            }
            while (index < types.length) {
                type = types[index];
                if (!type.isBinary() && !type.isReadOnly()) {
                    this.adjustIncomingVisibility((IMember)type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        monitor.done();
    }

    private void adjustIncomingVisibility(SearchMatch match, IProgressMonitor monitor) throws JavaModelException {
        Object element = match.getElement();
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member instanceof IInitializer) {
                member = member.getDeclaringType();
            }
            if (member != null) {
                this.adjustIncomingVisibility(member, monitor);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustIncomingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            SearchMatch[] matches = null;
            SearchResultGroup group = null;
            int index = 0;
            block3: while (index < groups.length) {
                group = groups[index];
                matches = group.getSearchResults();
                int offset = 0;
                while (true) {
                    if (offset >= matches.length) {
                        monitor.worked(1);
                        ++index;
                        continue block3;
                    }
                    this.adjustIncomingVisibility(matches[offset], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++offset;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    private void adjustOutgoingVisibility(ICompilationUnit unit, IField field, Modifier.ModifierKeyword threshold) throws JavaModelException {
        Assert.isTrue(!field.isBinary() && !field.isReadOnly());
        if (MemberVisibilityAdjustor.hasLowerVisibility(field.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment((IMember)field, threshold)) {
            if (this.fGetters) {
                try {
                    IMethod getter = GetterSetterUtil.getGetter(field);
                    if (getter != null && getter.exists()) {
                        this.adjustOutgoingVisibility(unit, (IMember)getter, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
                        this.fAdjustments.put(field, new OutgoingAccessorVisibilityAdjustment(field, getter, true, threshold, new RefactoringStatus()));
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            } else if (this.fSetters) {
                try {
                    IMethod setter = GetterSetterUtil.getSetter(field);
                    if (setter != null && setter.exists()) {
                        this.adjustOutgoingVisibility(unit, (IMember)setter, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
                        this.fAdjustments.put(field, new OutgoingAccessorVisibilityAdjustment(field, setter, false, threshold, new RefactoringStatus()));
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
            this.adjustOutgoingVisibility(unit, (IMember)field, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning);
        }
    }

    private void adjustOutgoingVisibility(ICompilationUnit unit, IMember member, Modifier.ModifierKeyword threshold, String template) throws JavaModelException {
        Assert.isTrue(!member.isBinary() && !member.isReadOnly());
        boolean adjust = true;
        IType declaring = member.getDeclaringType();
        if (declaring != null && (JavaModelUtil.isInterfaceOrAnnotation(declaring) || declaring.equals(this.fReferenced))) {
            adjust = false;
        }
        if (adjust && MemberVisibilityAdjustor.hasLowerVisibility(member.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment(member, threshold)) {
            this.fAdjustments.put(member, new OutgoingMemberVisibilityAdjustment(member, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(template, new String[]{JavaElementLabels.getTextLabel(member, 1L), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(member), null, (int)-1, null)));
        }
    }

    private void adjustOutgoingVisibility(ICompilationUnit unit, SearchMatch match, IProgressMonitor monitor) throws JavaModelException {
        IMember member;
        Object element = match.getElement();
        if (element instanceof IMember && !(member = (IMember)element).isBinary() && !member.isReadOnly()) {
            Modifier.ModifierKeyword threshold = this.computeOutgoingVisibilityThreshold(this.fReferencing, member, monitor);
            if (element instanceof IMethod) {
                this.adjustOutgoingVisibility(unit, member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
            } else if (element instanceof IField) {
                this.adjustOutgoingVisibility(unit, (IField)member, threshold);
            } else if (element instanceof IType) {
                this.adjustOutgoingVisibility(unit, member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustOutgoingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            IJavaElement element = null;
            ICompilationUnit unit = null;
            SearchMatch[] matches = null;
            SearchResultGroup group = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                element = JavaCore.create((IResource)group.getResource());
                if (element instanceof ICompilationUnit) {
                    unit = (ICompilationUnit)element;
                    matches = group.getSearchResults();
                    int offset = 0;
                    while (offset < matches.length) {
                        this.adjustOutgoingVisibility(unit, matches[offset], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++offset;
                    }
                }
                monitor.worked(1);
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void adjustVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", 7);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fReferenced, (int)2, (int)24));
            engine.setScope(this.fScope);
            engine.setStatus(this.fStatus);
            if (this.fIncoming) {
                engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.adjustIncomingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                engine.clearResults();
                if (this.fReferenced instanceof IType) {
                    IType type = (IType)this.fReferenced;
                    this.adjustIncomingVisibility(type.getTypes(), type.getMethods(), type.getFields(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            if (this.fOutgoing) {
                engine.searchReferencedTypes((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedFields((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedMethods((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                this.adjustOutgoingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Modifier.ModifierKeyword computeIncomingVisibilityThreshold(IMember referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue(!(referencing instanceof IInitializer));
        Assert.isTrue(!(referenced instanceof IInitializer));
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int referencingType = referencing.getElementType();
            int referencedType = referenced.getElementType();
            switch (referencedType) {
                case 7: {
                    IType typeReferenced = (IType)referenced;
                    ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                            break;
                        }
                        case 8: {
                            IField field = (IField)referencing;
                            if (typeReferenced.equals(field.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(field.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!typeReferenced.getPackageFragment().equals(field.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 9: {
                            IMethod method = (IMethod)referencing;
                            if (typeReferenced.equals(method.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(method.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!typeReferenced.getPackageFragment().equals(method.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField fieldReferenced = (IField)referenced;
                    ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                            break;
                        }
                        case 8: {
                            IField field = (IField)referencing;
                            if (fieldReferenced.getDeclaringType().equals(field.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(field.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(field.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 9: {
                            IMethod method = (IMethod)referencing;
                            if (fieldReferenced.getDeclaringType().equals(method.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(method.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(method.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod methodReferenced = (IMethod)referenced;
                    ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                            break;
                        }
                        case 8: {
                            IField field = (IField)referencing;
                            if (methodReferenced.getDeclaringType().equals(field.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(field.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(field.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 9: {
                            IMethod method = (IMethod)referencing;
                            if (methodReferenced.getDeclaringType().equals(method.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(method.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(method.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue(false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        monitor.done();
        return keyword;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Modifier.ModifierKeyword computeOutgoingVisibilityThreshold(IJavaElement referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue(referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment);
        Assert.isTrue(referenced instanceof IType || referenced instanceof IField || referenced instanceof IMethod);
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int referencingType = referencing.getElementType();
            int referencedType = referenced.getElementType();
            switch (referencedType) {
                case 7: {
                    IType typeReferenced = (IType)referenced;
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!typeReferenced.getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField fieldReferenced = (IField)referenced;
                    ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod methodReferenced = (IMethod)referenced;
                    ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue(false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue(false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        monitor.done();
        return keyword;
    }

    public final Map getAdjustments() {
        return this.fAdjustments;
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit) {
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)this.fRewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
        }
        return rewrite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor monitor) throws JavaModelException {
        ITypeHierarchy hierarchy = null;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            try {
                hierarchy = (ITypeHierarchy)this.fTypeHierarchies.get(type);
                if (hierarchy == null) {
                    hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
        return hierarchy;
    }

    private boolean needsVisibilityAdjustment(IMember member, Modifier.ModifierKeyword threshold) {
        Assert.isNotNull(member);
        return MemberVisibilityAdjustor.needsVisibilityAdjustments(member, threshold, this.fAdjustments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member = null;
            IVisibilityAdjustment adjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                member = (IMember)iterator.next();
                if (!unit.equals(member.getCompilationUnit()) || (adjustment = (IVisibilityAdjustment)this.fAdjustments.get(member)) == null) continue;
                adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fTypeHierarchies.clear();
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fTypeHierarchies.clear();
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member = null;
            IVisibilityAdjustment adjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                member = (IMember)iterator.next();
                adjustment = (IVisibilityAdjustment)this.fAdjustments.get(member);
                if (adjustment == null) continue;
                adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fTypeHierarchies.clear();
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fTypeHierarchies.clear();
        }
        monitor.done();
    }

    public final void setAdjustments(Map adjustments) {
        Assert.isNotNull(adjustments);
        this.fAdjustments = adjustments;
    }

    public final void setFailureSeverity(int severity) {
        Assert.isTrue(MemberVisibilityAdjustor.isStatusSeverity(severity));
        this.fFailureSeverity = severity;
    }

    public final void setGetters(boolean use) {
        this.fGetters = use;
    }

    public final void setIncoming(boolean incoming) {
        this.fIncoming = incoming;
    }

    public final void setOutgoing(boolean outgoing) {
        this.fOutgoing = outgoing;
    }

    public final void setRewrite(ASTRewrite rewrite, CompilationUnit root) {
        Assert.isTrue(rewrite == null || root != null);
        this.fRewrite = rewrite;
        this.fRoot = root;
    }

    public final void setRewrites(Map rewrites) {
        Assert.isNotNull(rewrites);
        this.fRewrites = rewrites;
    }

    public final void setScope(IJavaSearchScope scope) {
        Assert.isNotNull(scope);
        this.fScope = scope;
    }

    public final void setSetters(boolean use) {
        this.fSetters = use;
    }

    public final void setStatus(RefactoringStatus status) {
        Assert.isNotNull(status);
        this.fStatus = status;
    }

    public final void setVisibilitySeverity(int severity) {
        Assert.isTrue(MemberVisibilityAdjustor.isStatusSeverity(severity));
        this.fVisibilitySeverity = severity;
    }

    private Modifier.ModifierKeyword thresholdTypeToField(IType referencing, IField referenced, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToMethod(IType referencing, IMethod referenced, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        Object keyword = null;
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType().getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToType(IType referencing, IType referenced, IProgressMonitor monitor) throws JavaModelException {
        Object keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referencing.equals(referenced.getDeclaringType())) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced)) {
                    keyword = null;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    public static class IncomingMemberVisibilityAdjustment
    implements IVisibilityAdjustment {
        protected final Modifier.ModifierKeyword fKeyword;
        protected final IMember fMember;
        protected boolean fNeedsRewriting = true;
        protected final RefactoringStatus fRefactoringStatus;

        public IncomingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            Assert.isNotNull(member);
            Assert.isTrue(!(member instanceof IInitializer));
            Assert.isTrue(MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
            this.fMember = member;
            this.fKeyword = keyword;
            this.fRefactoringStatus = status;
        }

        public final Modifier.ModifierKeyword getKeyword() {
            return this.fKeyword;
        }

        public final IMember getMember() {
            return this.fMember;
        }

        public final RefactoringStatus getStatus() {
            return this.fRefactoringStatus;
        }

        public final boolean needsRewriting() {
            return this.fNeedsRewriting;
        }

        protected final void rewriteVisibility(MemberVisibilityAdjustor adjustor, ASTRewrite rewrite, CompilationUnit root, TextEditGroup group, RefactoringStatus status) throws JavaModelException {
            BodyDeclaration declaration;
            int visibility;
            Assert.isNotNull(adjustor);
            Assert.isNotNull(rewrite);
            Assert.isNotNull(root);
            int n = visibility = this.fKeyword != null ? this.fKeyword.toFlagValue() : 0;
            if (this.fMember instanceof IField && !Flags.isEnum((int)this.fMember.getFlags())) {
                VariableDeclarationFragment fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)this.fMember, root);
                FieldDeclaration declaration2 = (FieldDeclaration)fragment.getParent();
                if (declaration2.fragments().size() == 1) {
                    ModifierRewrite.create(rewrite, (ASTNode)declaration2).setVisibility(visibility, group);
                } else {
                    VariableDeclarationFragment newFragment = rewrite.getAST().newVariableDeclarationFragment();
                    newFragment.setName((SimpleName)rewrite.createCopyTarget((ASTNode)fragment.getName()));
                    FieldDeclaration newDeclaration = rewrite.getAST().newFieldDeclaration(newFragment);
                    newDeclaration.setType((Type)rewrite.createCopyTarget((ASTNode)declaration2.getType()));
                    IExtendedModifier extended = null;
                    Iterator iterator = declaration2.modifiers().iterator();
                    while (iterator.hasNext()) {
                        Modifier modifier;
                        int flag;
                        extended = (IExtendedModifier)iterator.next();
                        if (extended.isModifier() && ((flag = (modifier = (Modifier)extended).getKeyword().toFlagValue()) & 7) != 0) continue;
                        newDeclaration.modifiers().add(rewrite.createCopyTarget((ASTNode)extended));
                    }
                    ModifierRewrite.create(rewrite, (ASTNode)newDeclaration).setVisibility(visibility, group);
                    AbstractTypeDeclaration type = (AbstractTypeDeclaration)declaration2.getParent();
                    rewrite.getListRewrite((ASTNode)type, type.getBodyDeclarationsProperty()).insertAfter((ASTNode)newDeclaration, (ASTNode)declaration2, null);
                    ListRewrite list = rewrite.getListRewrite((ASTNode)declaration2, FieldDeclaration.FRAGMENTS_PROPERTY);
                    list.remove((ASTNode)fragment, group);
                    if (list.getRewrittenList().isEmpty()) {
                        rewrite.remove((ASTNode)declaration2, null);
                    }
                }
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            } else if (this.fMember != null && (declaration = ASTNodeSearchUtil.getBodyDeclarationNode(this.fMember, root)) != null) {
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setVisibility(visibility, group);
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull(adjustor);
            Assert.isNotNull(monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    if (adjustor.fRewrite != null && adjustor.fRoot != null) {
                        this.rewriteVisibility(adjustor, adjustor.fRewrite, adjustor.fRoot, null, this.fRefactoringStatus);
                    } else {
                        CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                        this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword()))), this.fRefactoringStatus);
                    }
                } else if (this.fRefactoringStatus != null) {
                    adjustor.fStatus.merge(this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }

        public final void setNeedsRewriting(boolean rewriting) {
            this.fNeedsRewriting = rewriting;
        }
    }

    public static interface IVisibilityAdjustment {
        public void rewriteVisibility(MemberVisibilityAdjustor var1, IProgressMonitor var2) throws JavaModelException;
    }

    public static class OutgoingAccessorVisibilityAdjustment
    extends OutgoingMemberVisibilityAdjustment {
        protected final IMethod fAccessor;
        protected final boolean fGetter;

        public OutgoingAccessorVisibilityAdjustment(IField field, IMethod accessor, boolean getter, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            super((IMember)field, keyword, status);
            Assert.isNotNull(accessor);
            this.fAccessor = accessor;
            this.fGetter = getter;
        }

        public final IMethod getAccessor() {
            return this.fAccessor;
        }

        public final boolean isGetter() {
            return this.fGetter;
        }
    }

    public static class OutgoingMemberVisibilityAdjustment
    extends IncomingMemberVisibilityAdjustment {
        public OutgoingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            super(member, keyword, status);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull(adjustor);
            Assert.isNotNull(monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                    this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword()))), this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }
    }
}

