/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;

public class ExternalToolsUtil {
    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.externaltools", code, message, exception));
    }

    public static IPath getLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        if (location == null) {
            ExternalToolsUtil.abort(MessageFormat.format(ExternalToolsLaunchConfigurationMessages.ExternalToolsUtil_Location_not_specified_by__0__1, configuration.getName()), null, 0);
        } else {
            String expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location);
            if (expandedLocation == null || expandedLocation.length() == 0) {
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.ExternalToolsUtil_invalidLocation__0_, configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            } else {
                File file = new File(expandedLocation);
                if (file.isFile()) {
                    return new Path(expandedLocation);
                }
                String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.ExternalToolsUtil_invalidLocation__0_, configuration.getName());
                ExternalToolsUtil.abort(msg, null, 0);
            }
        }
        return null;
    }

    public static boolean getCaptureOutput(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.debug.core.capture_output", true);
    }

    public static IPath getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", null);
        if (location != null && (expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            String msg = MessageFormat.format(ExternalToolsLaunchConfigurationMessages.ExternalToolsUtil_invalidDirectory__0_, expandedLocation, configuration.getName());
            ExternalToolsUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static String[] getArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        if (args != null) {
            String expanded = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(args);
            return ExternalToolsUtil.parseStringIntoList(expanded);
        }
        return null;
    }

    private static IStringVariableManager getStringVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    public static boolean isBuilderEnabled(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", true);
    }

    public static IResource[] getResourcesForBuildScope(ILaunchConfiguration configuration) throws CoreException {
        String scope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        if (scope == null) {
            return null;
        }
        return RefreshTab.getRefreshResources((String)scope);
    }

    public static String[] parseStringIntoList(String arguments) {
        if (arguments == null || arguments.length() == 0) {
            return new String[0];
        }
        String[] res = DebugPlugin.parseArguments((String)arguments);
        return res;
    }
}

