/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsLaunchConfigurationMessages;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class ExternalToolsBuilderTab
extends AbstractLaunchConfigurationTab {
    protected Button afterClean;
    protected Button fDuringClean;
    protected Button autoBuildButton;
    protected Button manualBuild;
    protected Button workingSetButton;
    protected Button specifyResources;
    protected Button fLaunchInBackgroundButton;
    protected IWorkingSet workingSet;
    protected ILaunchConfiguration fConfiguration;
    private boolean fCreateBuildScheduleComponent = true;
    protected SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean enabled = !ExternalToolsBuilderTab.this.fCreateBuildScheduleComponent || ExternalToolsBuilderTab.this.autoBuildButton.getSelection() || ExternalToolsBuilderTab.this.manualBuild.getSelection();
            ExternalToolsBuilderTab.this.workingSetButton.setEnabled(enabled);
            ExternalToolsBuilderTab.this.specifyResources.setEnabled(enabled && ExternalToolsBuilderTab.this.workingSetButton.getSelection());
            ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
        }
    };

    public ExternalToolsBuilderTab() {
    }

    public ExternalToolsBuilderTab(boolean createBuildScheduleComponent) {
        this.fCreateBuildScheduleComponent = createBuildScheduleComponent;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.externaltools.builders_tab_context");
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createLaunchInBackgroundComposite(mainComposite);
        this.createVerticalSpacer(mainComposite, 2);
        this.createBuildScheduleComponent(mainComposite);
    }

    protected void createLaunchInBackgroundComposite(Composite parent) {
        this.fLaunchInBackgroundButton = this.createCheckButton(parent, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_14);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fLaunchInBackgroundButton.setLayoutData((Object)data);
        this.fLaunchInBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createBuildScheduleComponent(Composite parent) {
        if (this.fCreateBuildScheduleComponent) {
            Label label = new Label(parent, 0);
            label.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Run_this_builder_for__1);
            label.setFont(parent.getFont());
            this.afterClean = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Full_builds_2, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Full, 2);
            this.manualBuild = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Incremental_builds_4, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Inc, 2);
            this.autoBuildButton = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab__Auto_builds__Not_recommended__6, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Auto, 2);
            this.fDuringClean = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_0, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_1, 2);
            this.createVerticalSpacer(parent, 2);
        }
        this.workingSetButton = this.createButton(parent, this.selectionListener, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_workingSet_label, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_workingSet_tooltip, 1);
        this.specifyResources = this.createPushButton(parent, ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_13, null);
        GridData gd = new GridData(128);
        this.specifyResources.setLayoutData((Object)gd);
        this.specifyResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalToolsBuilderTab.this.selectResources();
            }
        });
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_2);
        label.setFont(parent.getFont());
    }

    protected Button createButton(Composite parent, SelectionListener listener, String text, String tooltipText, int columns) {
        Button button = this.createCheckButton(parent, text);
        button.setToolTipText(tooltipText);
        button.addSelectionListener(listener);
        GridData gd = new GridData(768);
        gd.horizontalSpan = columns;
        button.setLayoutData((Object)gd);
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer("full");
        buffer.append(',');
        buffer.append("incremental");
        buffer.append(',');
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
        configuration.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
        if (this.fCreateBuildScheduleComponent) {
            this.afterClean.setSelection(false);
            this.manualBuild.setSelection(false);
            this.autoBuildButton.setSelection(false);
            this.fDuringClean.setSelection(false);
        }
        String buildKindString = null;
        String buildScope = null;
        try {
            buildKindString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", "");
            buildScope = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        }
        catch (CoreException coreException) {}
        this.workingSetButton.setSelection(buildScope != null);
        this.workingSetButton.setEnabled(buildScope != null);
        if (buildScope != null) {
            this.workingSet = RefreshTab.getWorkingSet((String)buildScope);
        }
        if (this.fCreateBuildScheduleComponent) {
            int[] buildTypes = BuilderUtils.buildTypesToArray(buildKindString);
            int i = 0;
            while (i < buildTypes.length) {
                switch (buildTypes[i]) {
                    case 6: {
                        this.afterClean.setSelection(true);
                        break;
                    }
                    case 10: {
                        this.manualBuild.setSelection(true);
                        break;
                    }
                    case 9: {
                        this.autoBuildButton.setSelection(true);
                        break;
                    }
                    case 15: {
                        this.fDuringClean.setSelection(true);
                    }
                }
                ++i;
            }
        }
        boolean enabled = true;
        if (this.fCreateBuildScheduleComponent) {
            enabled = this.autoBuildButton.getSelection() || this.manualBuild.getSelection();
        }
        this.workingSetButton.setEnabled(enabled);
        this.specifyResources.setEnabled(enabled && this.workingSetButton.getSelection());
        this.updateRunInBackground(configuration);
    }

    protected void updateRunInBackground(ILaunchConfiguration configuration) {
        this.fLaunchInBackgroundButton.setSelection(ExternalToolsBuilderTab.isLaunchInBackground(configuration));
    }

    public static boolean isLaunchInBackground(ILaunchConfiguration configuration) {
        boolean launchInBackground = false;
        try {
            launchInBackground = configuration.getAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
        }
        catch (CoreException ce) {
            ExternalToolsPlugin.getDefault().log(ce);
        }
        return launchInBackground;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fCreateBuildScheduleComponent) {
            StringBuffer buffer = new StringBuffer();
            if (this.afterClean.getSelection()) {
                buffer.append("full").append(',');
            }
            if (this.manualBuild.getSelection()) {
                buffer.append("incremental").append(',');
            }
            if (this.autoBuildButton.getSelection()) {
                buffer.append("auto").append(',');
            }
            if (this.fDuringClean.getSelection()) {
                buffer.append("clean");
            }
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
        }
        if (this.workingSetButton.getSelection()) {
            String scope = RefreshTab.getRefreshAttribute((IWorkingSet)this.workingSet);
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", scope);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILD_SCOPE", null);
        }
        configuration.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, this.fLaunchInBackgroundButton.getSelection());
    }

    public String getName() {
        return ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_Build_Options_9;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fCreateBuildScheduleComponent) {
            boolean buildKindSelected;
            boolean bl = buildKindSelected = this.afterClean.getSelection() || this.manualBuild.getSelection() || this.autoBuildButton.getSelection() || this.fDuringClean.getSelection();
            if (!buildKindSelected) {
                this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_buildKindError);
                return false;
            }
        }
        if (this.workingSetButton.getSelection() && (this.workingSet == null || this.workingSet.getElements().length == 0)) {
            this.setErrorMessage(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_16);
            return false;
        }
        return true;
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    private void selectResources() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (this.workingSet == null) {
            this.workingSet = workingSetManager.createWorkingSet(ExternalToolsLaunchConfigurationMessages.ExternalToolsBuilderTab_15, new IAdaptable[0]);
        }
        IWorkingSetEditWizard wizard = workingSetManager.createWorkingSetEditWizard(this.workingSet);
        WizardDialog dialog = new WizardDialog(ExternalToolsPlugin.getStandardDisplay().getActiveShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 1) {
            return;
        }
        this.workingSet = wizard.getSelection();
        this.updateLaunchConfigurationDialog();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

