/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.util.BundleUtil;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntroExtensionContent
extends AbstractIntroElement {
    protected static final String TAG_CONTAINER_EXTENSION = "extensionContent";
    protected static final String ATT_PATH = "path";
    private static final String ATT_STYLE = "style";
    private static final String ATT_ALT_STYLE = "alt-style";
    private static final String ATT_CONTENT = "content";
    private String path;
    private String content;
    private Element element;
    private String base;
    private Vector styles = new Vector();
    private Hashtable altStyles = new Hashtable();

    IntroExtensionContent(Element element, Bundle bundle, String base) {
        super(element, bundle);
        this.path = this.getAttribute(element, ATT_PATH);
        this.content = this.getAttribute(element, ATT_CONTENT);
        this.element = element;
        this.base = base;
        this.init(element, bundle, base);
        if (this.content != null) {
            IPath subBase = ModelUtil.getParentFolderPath(this.content);
            String newBase = new Path(base).append(subBase).toString();
            this.content = BundleUtil.getResolvedResourceLocation(base, this.content, bundle);
            this.base = newBase;
        }
    }

    private void init(Element element, Bundle bundle, String base) {
        String[] altStyleValues;
        String[] styleValues = this.getAttributeList(element, ATT_STYLE);
        if (styleValues != null && styleValues.length > 0) {
            int i = 0;
            while (i < styleValues.length) {
                String style = styleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addStyle(style);
                ++i;
            }
        }
        if ((altStyleValues = this.getAttributeList(element, ATT_ALT_STYLE)) != null && altStyleValues.length > 0) {
            int i = 0;
            while (i < altStyleValues.length) {
                String style = altStyleValues[i];
                style = BundleUtil.getResolvedResourceLocation(base, style, bundle);
                this.addAltStyle(style, bundle);
                ++i;
            }
        }
    }

    protected void addStyle(String style) {
        if (this.styles.contains(style)) {
            return;
        }
        this.styles.add(style);
    }

    protected void addAltStyle(String altStyle, Bundle bundle) {
        if (this.altStyles.containsKey(altStyle)) {
            return;
        }
        this.altStyles.put(altStyle, bundle);
    }

    public String getPath() {
        return this.path;
    }

    public int getType() {
        return 1024;
    }

    protected Element[] getChildren() {
        NodeList nodeList = this.element.getChildNodes();
        Vector<Node> vector = new Vector<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                vector.add(node);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        this.element = null;
        return filteredElements;
    }

    public boolean isXHTMLContent() {
        return this.content != null;
    }

    public Document getDocument() {
        if (this.isXHTMLContent()) {
            IntroContentParser parser = new IntroContentParser(this.content);
            Document dom = parser.getDocument();
            if (dom == null) {
                return null;
            }
            if (parser.hasXHTMLContent()) {
                return dom;
            }
        }
        return null;
    }

    protected Hashtable getAltStyles() {
        return this.altStyles;
    }

    protected String[] getStyles() {
        Object[] stylesArray = new String[this.styles.size()];
        this.styles.copyInto(stylesArray);
        return stylesArray;
    }

    public String getContent() {
        return this.content;
    }

    public String getBase() {
        return this.base;
    }
}

