/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.ConvertLineDelimitersOperation;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.editors.text.FileBufferOperationAction;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class ConvertLineDelimitersAction
extends FileBufferOperationAction {
    private String fLabel;

    protected ConvertLineDelimitersAction(String lineDelimiter, String label) {
        super((IFileBufferOperation)new ConvertLineDelimitersOperation(lineDelimiter));
        this.setText(ConvertLineDelimitersAction.constructLabel(label, lineDelimiter, System.getProperty("line.separator")));
        this.fLabel = Action.removeMnemonics((String)label);
    }

    private static String constructLabel(String label, String lineDelimiter, String platformLineDelimiter) {
        if (lineDelimiter.equals(platformLineDelimiter)) {
            return String.valueOf(label) + TextEditorMessages.ConvertLineDelimitersAction_default_label;
        }
        return label;
    }

    protected boolean isAcceptableLocation(IPath location) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return manager.isTextFileLocation(location);
    }

    protected IFile[] collectFiles(IResource[] resources) {
        IFile[] files = super.collectFiles(resources);
        if (files != null && resources != null && files.length == resources.length) {
            return files;
        }
        SelectResourcesDialog dialog = new SelectResourcesDialog(this.getShell(), NLSUtility.format(TextEditorMessages.ConvertLineDelimitersAction_dialog_title, this.fLabel), TextEditorMessages.ConvertLineDelimitersAction_dialog_description);
        dialog.setInput(resources);
        int result = dialog.open();
        if (result == 0) {
            IResource[] selectedResources = dialog.getSelectedResources();
            return super.collectFiles(selectedResources);
        }
        return null;
    }
}

