/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleConfigScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;

public class AssembleScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected AssemblyInformation assemblageInformation;
    protected String featureId;
    protected HashMap archivesFormat;
    protected AssembleConfigScriptGenerator configScriptGenerator;

    public AssembleScriptGenerator(String directory, AssemblyInformation assemblageInformation, String featureId) throws CoreException {
        this.directory = directory;
        this.assemblageInformation = assemblageInformation;
        this.featureId = featureId;
        this.configScriptGenerator = this.getConfigScriptGenerator();
    }

    protected String getScriptName() {
        return "assemble." + (this.featureId.equals("") ? "" : String.valueOf(this.featureId) + '.') + "all.xml";
    }

    protected AssembleConfigScriptGenerator getConfigScriptGenerator() {
        return new AssembleConfigScriptGenerator();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        try {
            this.openScript(this.directory, this.getScriptName());
            this.printProjectDeclaration();
            this.generateMainTarget();
            this.script.printProjectEnd();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.script.close();
            this.script = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.script.close();
            this.script = null;
            return;
        }
    }

    protected void printProjectDeclaration() {
        this.script.printProjectDeclaration("Assemble All Config of " + this.featureId, "main", null);
    }

    protected void generateMainTarget() throws CoreException {
        this.script.printTargetDeclaration("main", null, null, null, null);
        Iterator iter = AssembleScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            this.generateAssembleConfigFileTargetCall((Config)iter.next());
        }
        this.script.printTargetEnd();
    }

    protected void generateAssembleConfigFileTargetCall(Config aConfig) throws CoreException {
        this.configScriptGenerator.initialize(this.directory, this.featureId, aConfig, this.assemblageInformation.getCompiledPlugins(aConfig), this.assemblageInformation.getCompiledFeatures(aConfig), this.assemblageInformation.getFeatures(aConfig), this.assemblageInformation.getRootFileProviders(aConfig));
        this.configScriptGenerator.setArchiveFormat((String)this.archivesFormat.get(aConfig));
        this.configScriptGenerator.setBuildSiteFactory(this.siteFactory);
        this.configScriptGenerator.generate();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("assembleScriptName", String.valueOf(this.configScriptGenerator.getTargetName()) + ".xml");
        this.script.printAntTask(Utils.getPropertyFormat("customTargets"), null, this.configScriptGenerator.getTargetName(), null, null, params);
    }

    public void setSignJars(boolean value) {
        this.configScriptGenerator.setSignJars(value);
    }

    public void setProduct(String value) {
        this.configScriptGenerator.setProduct(value);
    }

    public void setGenerateJnlp(boolean value) {
        this.configScriptGenerator.setGenerateJnlp(value);
    }

    public void setArchivesFormat(HashMap outputFormat) {
        this.archivesFormat = outputFormat;
    }
}

