/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.core.refactoring.JDTDebugRefactoringUtil;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class LaunchConfigurationProjectMainTypeChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private String fNewMainTypeName;
    private String fNewProjectName;
    private String fNewLaunchConfigurationName;
    private String fOldMainTypeName;
    private String fOldProjectName;
    private ILaunchConfigurationWorkingCopy fNewLaunchConfiguration;
    private String fNewConfigContainerName;

    public static Change createChangesForTypeRename(IType type, String newName) throws CoreException {
        IPackageFragment packageFragment;
        IType declaringType = type.getDeclaringType();
        String newFullyQualifiedName = declaringType == null ? ((packageFragment = type.getPackageFragment()).isDefaultPackage() ? newName : String.valueOf(packageFragment.getElementName()) + '.' + newName) : String.valueOf(declaringType.getFullyQualifiedName()) + '$' + newName;
        return LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(type, newFullyQualifiedName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Change createChangesForTypeMove(IType type, IJavaElement destination) throws CoreException {
        void var4_4;
        String newFullyQualifiedName;
        IJavaProject projectDestination = destination.getJavaProject();
        String newProjectName = type.getJavaProject().equals(projectDestination) ? null : projectDestination.getElementName();
        if (destination instanceof IType) {
            newFullyQualifiedName = String.valueOf(((IType)destination).getFullyQualifiedName()) + '$' + type.getElementName();
        } else if (destination instanceof IPackageFragment) {
            IPackageFragment destinationPackage = (IPackageFragment)destination;
            newFullyQualifiedName = destinationPackage.isDefaultPackage() ? type.getElementName() : String.valueOf(destination.getElementName()) + '.' + type.getElementName();
        } else {
            return null;
        }
        return LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(type, (String)var4_4, newProjectName);
    }

    public static Change createChangesForProjectRename(IJavaProject javaProject, String newProjectName) throws CoreException {
        String projectName = javaProject.getElementName();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForProjectRename(javaProject, configs, projectName, newProjectName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForProjectRename(javaProject, configs, projectName, newProjectName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForPackageRename(IPackageFragment packageFragment, String newName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForPackageRename(configs, packageFragment, newName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForPackageRename(configs, packageFragment, newName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForPackageMove(IPackageFragment packageFragment, IPackageFragmentRoot destination) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForPackageMove(configs, packageFragment, destination);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForPackageMove(configs, packageFragment, destination));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    private static Change createChangesForTypeChange(IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfiguration[] configs = manager.getLaunchConfigurations(configurationType);
        List changes = LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(configs, type, newFullyQualifiedName, newProjectName);
        configurationType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLET);
        configs = manager.getLaunchConfigurations(configurationType);
        changes.addAll(LaunchConfigurationProjectMainTypeChange.createChangesForTypeChange(configs, type, newFullyQualifiedName, newProjectName));
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    private static List createChangesForTypeChange(ILaunchConfiguration[] configs, IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        String typeName = type.getFullyQualifiedName();
        String projectName = type.getJavaProject().getElementName();
        int i = 0;
        while (i < configs.length) {
            String mainTypeName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(lcProjectName) && (mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null)).startsWith(typeName)) {
                if (typeName.equals(mainTypeName)) {
                    changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newFullyQualifiedName, newProjectName));
                } else {
                    Change change = LaunchConfigurationProjectMainTypeChange.createChangesForOuterTypeChange(launchConfiguration, type, newFullyQualifiedName, newProjectName);
                    if (change != null) {
                        changes.add(change);
                    }
                }
            }
            ++i;
        }
        return changes;
    }

    private static Change createChangesForOuterTypeChange(ILaunchConfiguration launchConfiguration, IType type, String newFullyQualifiedName, String newProjectName) throws CoreException {
        IType[] innerTypes = type.getTypes();
        String mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        int i = 0;
        while (i < innerTypes.length) {
            IType innerType = innerTypes[i];
            String innerTypeName = innerType.getFullyQualifiedName();
            if (mainTypeName.startsWith(innerTypeName)) {
                String newTypeName = String.valueOf(newFullyQualifiedName) + '$' + innerType.getElementName();
                if (innerTypeName.equals(mainTypeName)) {
                    return new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newTypeName, newProjectName);
                }
                return LaunchConfigurationProjectMainTypeChange.createChangesForOuterTypeChange(launchConfiguration, innerType, newTypeName, newProjectName);
            }
            ++i;
        }
        return null;
    }

    private static List createChangesForProjectRename(IJavaProject javaProject, ILaunchConfiguration[] configs, String projectName, String newProjectName) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration launchConfiguration = configs[i];
            String launchConfigurationProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(launchConfigurationProjectName)) {
                LaunchConfigurationProjectMainTypeChange change = new LaunchConfigurationProjectMainTypeChange(launchConfiguration, null, newProjectName);
                String newContainerName = LaunchConfigurationProjectMainTypeChange.computeNewContainerName(javaProject, launchConfiguration);
                if (newContainerName != null) {
                    change.setNewContainerName(newContainerName);
                }
                changes.add(change);
            }
            ++i;
        }
        return changes;
    }

    private void setNewContainerName(String newContainerName) {
        this.fNewConfigContainerName = newContainerName;
    }

    private static String computeNewContainerName(IJavaProject javaProject, ILaunchConfiguration launchConfiguration) {
        IPath currentLocation = launchConfiguration.getLocation();
        IProject project = javaProject.getProject();
        IPath projectLocation = project.getLocation();
        if (projectLocation.isPrefixOf(currentLocation)) {
            String projectFile = new File(projectLocation.toOSString()).getAbsolutePath();
            String configDir = new File(currentLocation.toOSString()).getParent();
            return new String(configDir.substring(projectFile.length()));
        }
        return null;
    }

    private static List createChangesForPackageRename(ILaunchConfiguration[] configs, IPackageFragment packageFragment, String newName) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        String packageFragmentName = packageFragment.getElementName();
        String projectName = packageFragment.getJavaProject().getElementName();
        int i = 0;
        while (i < configs.length) {
            String mainTypeName;
            int index;
            String packageName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(lcProjectName) && packageFragmentName.equals(packageName = (index = (mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null)).lastIndexOf(46)) < 0 ? "" : mainTypeName.substring(0, index))) {
                String newTypeName = String.valueOf(newName) + '.' + mainTypeName.substring(index + 1);
                changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, newTypeName, null));
            }
            ++i;
        }
        return changes;
    }

    private static List createChangesForPackageMove(ILaunchConfiguration[] configs, IPackageFragment packageFragment, IPackageFragmentRoot destination) throws CoreException {
        ArrayList<LaunchConfigurationProjectMainTypeChange> changes = new ArrayList<LaunchConfigurationProjectMainTypeChange>();
        String packageFragmentName = packageFragment.getElementName();
        String projectName = packageFragment.getJavaProject().getElementName();
        int i = 0;
        while (i < configs.length) {
            String mainTypeName;
            int index;
            String packageName;
            ILaunchConfiguration launchConfiguration = configs[i];
            String lcProjectName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (projectName.equals(lcProjectName) && packageFragmentName.equals(packageName = (index = (mainTypeName = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null)).lastIndexOf(46)) < 0 ? "" : mainTypeName.substring(0, index))) {
                changes.add(new LaunchConfigurationProjectMainTypeChange(launchConfiguration, null, destination.getJavaProject().getElementName()));
            }
            ++i;
        }
        return changes;
    }

    private LaunchConfigurationProjectMainTypeChange(ILaunchConfiguration launchConfiguration, String newMainTypeName, String newProjectName) throws CoreException {
        this.fLaunchConfiguration = launchConfiguration;
        this.fNewLaunchConfiguration = launchConfiguration.getWorkingCopy();
        this.fNewMainTypeName = newMainTypeName;
        this.fNewProjectName = newProjectName;
        this.fOldMainTypeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        this.fOldProjectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (this.fNewMainTypeName != null) {
            String oldName = Signature.getSimpleName((String)this.fOldMainTypeName);
            String newName = Signature.getSimpleName((String)this.fNewMainTypeName);
            String launchConfigurationName = this.fLaunchConfiguration.getName();
            this.fNewLaunchConfigurationName = launchConfigurationName.replaceAll(oldName, newName);
            if (launchConfigurationName.equals(this.fNewLaunchConfigurationName) || DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewLaunchConfigurationName)) {
                this.fNewLaunchConfigurationName = null;
            }
        }
    }

    public String getName() {
        if (this.fNewLaunchConfigurationName != null) {
            return MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_0, this.fLaunchConfiguration.getName(), this.fNewLaunchConfigurationName);
        }
        if (this.fNewProjectName == null) {
            return MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_1, this.fLaunchConfiguration.getName());
        }
        if (this.fNewMainTypeName == null) {
            return MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_2, this.fLaunchConfiguration.getName());
        }
        return MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_3, this.fLaunchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fLaunchConfiguration.exists()) {
            String typeName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (this.fOldMainTypeName.equals(typeName)) {
                String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (this.fOldProjectName.equals(projectName)) {
                    return new RefactoringStatus();
                }
                return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_4, this.fLaunchConfiguration.getName(), this.fOldProjectName));
            }
            return RefactoringStatus.createWarningStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_5, this.fLaunchConfiguration.getName(), this.fOldMainTypeName));
        }
        return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringMessages.LaunchConfigurationProjectMainTypeChange_6, this.fLaunchConfiguration.getName()));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String oldProjectName;
        String oldMainTypeName;
        if (this.fNewConfigContainerName != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.fNewProjectName);
            IContainer container = (IContainer)project.findMember(this.fNewConfigContainerName);
            this.fNewLaunchConfiguration.setContainer(container);
        }
        if (this.fNewMainTypeName != null) {
            oldMainTypeName = this.fOldMainTypeName;
            this.fNewLaunchConfiguration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fNewMainTypeName);
        } else {
            oldMainTypeName = null;
        }
        if (this.fNewProjectName != null) {
            oldProjectName = this.fOldProjectName;
            this.fNewLaunchConfiguration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fNewProjectName);
        } else {
            oldProjectName = null;
        }
        if (this.fNewLaunchConfigurationName != null) {
            this.fNewLaunchConfiguration.rename(this.fNewLaunchConfigurationName);
        }
        this.fNewLaunchConfiguration.doSave();
        return new LaunchConfigurationProjectMainTypeChange((ILaunchConfiguration)this.fNewLaunchConfiguration, oldMainTypeName, oldProjectName);
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }
}

