/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class JavaWatchpointFieldNameChange
extends Change {
    private IJavaWatchpoint fWatchpoint;
    private String fNewName;
    private String fOldName;
    private IType fDeclaringType;

    public static Change createChange(IField field, String newName) throws CoreException {
        String typeName = field.getDeclaringType().getFullyQualifiedName();
        String fieldName = field.getElementName();
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaWatchpoint watchpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                return new JavaWatchpointFieldNameChange(watchpoint, newName);
            }
            ++i;
        }
        return null;
    }

    public JavaWatchpointFieldNameChange(IJavaWatchpoint watchpoint, String newName) throws CoreException {
        this.fWatchpoint = watchpoint;
        this.fNewName = newName;
        this.fOldName = this.fWatchpoint.getFieldName();
        this.fDeclaringType = BreakpointUtils.getType((IJavaBreakpoint)watchpoint);
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaWatchpointFieldNameChange_1, this.fDeclaringType.getElementName(), this.fOldName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.fWatchpoint.isRegistered()) {
            status.addFatalError(MessageFormat.format(RefactoringMessages.JavaWatchpointFieldNameChange_2, this.fDeclaringType.getElementName(), this.fOldName));
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IField newField = this.fDeclaringType.getField(this.fNewName);
        Map attributes = this.fWatchpoint.getMarker().getAttributes();
        boolean isAccess = this.fWatchpoint.isAccess();
        boolean isModification = this.fWatchpoint.isModification();
        boolean isEnable = this.fWatchpoint.isEnabled();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)newField);
        IJavaWatchpoint newWatchpoint = JDIDebugModel.createWatchpoint((IResource)this.fWatchpoint.getMarker().getResource(), (String)this.fWatchpoint.getTypeName(), (String)this.fNewName, (int)this.fWatchpoint.getLineNumber(), (int)this.fWatchpoint.getCharStart(), (int)this.fWatchpoint.getCharEnd(), (int)this.fWatchpoint.getHitCount(), (boolean)true, (Map)attributes);
        newWatchpoint.setAccess(isAccess);
        newWatchpoint.setModification(isModification);
        newWatchpoint.setEnabled(isEnable);
        this.fWatchpoint.delete();
        return new JavaWatchpointFieldNameChange(newWatchpoint, this.fOldName);
    }

    public Object getModifiedElement() {
        return this.fWatchpoint;
    }
}

