/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AppletMainTab
extends JavaLaunchConfigurationTab {
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Label fMainLabel;
    private Text fMainText;
    private Button fSearchButton;
    private Label fAppletViewerClassLabel;
    private Text fAppletViewerClassText;
    private Button fAppletViewerClassDefaultButton;
    private static final String EMPTY_STRING = "";
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AppletMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AppletMainTab.this.fSearchButton) {
                AppletMainTab.this.handleSearchButtonSelected();
            } else if (source == AppletMainTab.this.fProjButton) {
                AppletMainTab.this.handleProjectButtonSelected();
            } else if (source == AppletMainTab.this.fAppletViewerClassDefaultButton) {
                AppletMainTab.this.handleAppletViewerClassDefaultSelected();
            }
        }
    };

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite projComp = new Composite(parent, 0);
        this.setControl((Control)projComp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_APPLET_MAIN_TAB);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projComp.setLayout((Layout)projLayout);
        projComp.setFont(font);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LauncherMessages.appletlauncher_maintab_projectlabel_name);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(this.fModifyListener);
        this.fProjButton = this.createPushButton(projComp, LauncherMessages.appletlauncher_maintab_browselabel_name, null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.createVerticalSpacer(projComp, 2);
        this.fMainLabel = new Label(projComp, 0);
        this.fMainLabel.setText(LauncherMessages.appletlauncher_maintab_mainclasslabel_name);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fMainLabel.setLayoutData((Object)gd);
        this.fMainLabel.setFont(font);
        this.fMainText = new Text(projComp, 2052);
        gd = new GridData(256);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(this.fModifyListener);
        this.fSearchButton = this.createPushButton(projComp, LauncherMessages.appletlauncher_maintab_searchlabel_name, null);
        this.fSearchButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.createVerticalSpacer(projComp, 2);
        this.fAppletViewerClassLabel = new Label(projComp, 0);
        this.fAppletViewerClassLabel.setText(LauncherMessages.AppletMainTab_1);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAppletViewerClassLabel.setLayoutData((Object)gd);
        this.fAppletViewerClassLabel.setFont(font);
        this.fAppletViewerClassText = new Text(projComp, 2052);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fAppletViewerClassText.setLayoutData((Object)gd);
        this.fAppletViewerClassText.setFont(font);
        this.fAppletViewerClassText.addModifyListener(this.fModifyListener);
        this.fAppletViewerClassDefaultButton = this.createCheckButton(projComp, LauncherMessages.AppletMainTab_2);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAppletViewerClassDefaultButton.setLayoutData((Object)gd);
        this.fAppletViewerClassDefaultButton.addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    protected void setAppletViewerTextEnabledState() {
        if (this.isDefaultAppletViewerClassName()) {
            this.fAppletViewerClassText.setEnabled(false);
        } else {
            this.fAppletViewerClassText.setEnabled(true);
        }
    }

    protected boolean isDefaultAppletViewerClassName() {
        return this.fAppletViewerClassDefaultButton.getSelection();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.updateAppletViewerClassNameFromConfig(config);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    private void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = EMPTY_STRING;
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    private void updateAppletViewerClassNameFromConfig(ILaunchConfiguration config) {
        String appletViewerClassName = null;
        try {
            appletViewerClassName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, null);
            if (appletViewerClassName == null) {
                this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
                this.fAppletViewerClassDefaultButton.setSelection(true);
            } else {
                this.fAppletViewerClassText.setText(appletViewerClassName);
                this.fAppletViewerClassDefaultButton.setSelection(false);
            }
            this.setAppletViewerTextEnabledState();
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText());
        this.performApplyAppletViewerClassName(config);
    }

    private void performApplyAppletViewerClassName(ILaunchConfigurationWorkingCopy config) {
        String appletViewerClassName = null;
        if (!this.isDefaultAppletViewerClassName() && (appletViewerClassName = this.fAppletViewerClassText.getText().trim()).length() <= 0) {
            appletViewerClassName = null;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, appletViewerClassName);
    }

    public void dispose() {
    }

    private void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        Shell shell = this.getShell();
        AppletSelectionDialog dialog = new AppletSelectionDialog(shell, (IRunnableContext)this.getLaunchConfigurationDialog(), javaProject);
        dialog.setTitle(LauncherMessages.appletlauncher_maintab_selection_applet_dialog_title);
        dialog.setMessage(LauncherMessages.appletlauncher_maintab_selection_applet_dialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    private void handleAppletViewerClassDefaultSelected() {
        this.setAppletViewerTextEnabledState();
        if (this.isDefaultAppletViewerClassName()) {
            this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
        } else {
            this.fAppletViewerClassText.setText(EMPTY_STRING);
        }
    }

    private IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log(jme);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.appletlauncher_maintab_selection_project_dialog_title);
        dialog.setMessage(LauncherMessages.appletlauncher_maintab_selection_project_dialog_message);
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.appletlauncher_maintab_project_error_doesnotexist);
            return false;
        }
        name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.appletlauncher_maintab_type_error_doesnotexist);
            return false;
        }
        name = this.fAppletViewerClassText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.AppletMainTab_3);
            return false;
        }
        return true;
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeMainTypeAndName(javaElement, config);
        this.initializeHardCodedDefaults(config);
        this.initializeAppletViewerClass(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement je = this.getContext();
        if (je == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(je, config);
        }
    }

    private void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            if (javaElement.getElementType() == 5) {
                ICompilationUnit cu = (ICompilationUnit)javaElement;
                IType mainType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
                if (mainType.exists()) {
                    name = mainType.getFullyQualifiedName();
                }
            } else if (javaElement.getElementType() == 6) {
                try {
                    IType mainType = ((IClassFile)javaElement).getType();
                    name = mainType.getFullyQualifiedName();
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (name != null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
            if (name.length() > 0) {
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
                name = this.getLaunchConfigurationDialog().generateName(name);
                config.rename(name);
            }
        }
    }

    private void initializeDefaultVM(ILaunchConfigurationWorkingCopy config) {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstall.getVMInstallType().getId());
        }
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        this.initializeDefaultVM(config);
    }

    private void initializeAppletViewerClass(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, null);
    }

    public String getName() {
        return LauncherMessages.appletlauncher_maintab_name;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

