/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileContentManager;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardFileTypePage;
import org.eclipse.team.internal.ccvs.ui.wizards.ResizableWizard;
import org.eclipse.ui.PlatformUI;

public class AddWizard
extends ResizableWizard {
    private final AddOperation op;
    private final IFile[] unknowns;
    private CommitWizardFileTypePage fFileTypePage;

    public static void run(Shell shell, AddOperation op) throws InvocationTargetException, InterruptedException {
        try {
            IFile[] unknowns = AddWizard.getUnaddedWithUnknownFileType(op.getTraversals());
            if (unknowns.length == 0) {
                op.run();
            } else {
                AddWizard wizard = new AddWizard(op, unknowns);
                ResizableWizard.open(shell, wizard);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static IFile[] getUnaddedWithUnknownFileType(final ResourceTraversal[] traversals) throws InvocationTargetException, InterruptedException {
        final ArrayList unadded = new ArrayList();
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IFileContentManager manager = Team.getFileContentManager();
                int i = 0;
                while (i < traversals.length) {
                    ResourceTraversal traversal = traversals[i];
                    IResource[] resources = traversal.getResources();
                    int j = 0;
                    while (j < resources.length) {
                        IResource resource = resources[j];
                        try {
                            resource.accept(new IResourceVisitor(this, manager, unadded){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IFileContentManager val$manager;
                                private final /* synthetic */ List val$unadded;
                                {
                                    this.this$1 = var1_1;
                                    this.val$manager = iFileContentManager;
                                    this.val$unadded = list;
                                }

                                public boolean visit(IResource resource) throws CoreException {
                                    ICVSFile file;
                                    if (!(resource.getType() != 1 || (file = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource))).isManaged() || file.isIgnored() && !file.equals(resource))) {
                                        String extension = ((IFile)resource).getFileExtension();
                                        if (this.val$manager.getType((IStorage)((IFile)resource)) == 0) {
                                            if (extension != null && !this.val$manager.isKnownExtension(extension)) {
                                                this.val$unadded.add(resource);
                                            } else {
                                                String name = file.getName();
                                                if (extension == null && name != null && !this.val$manager.isKnownFilename(name)) {
                                                    this.val$unadded.add(resource);
                                                }
                                            }
                                        }
                                    }
                                    return true;
                                }
                            }, traversal.getDepth(), false);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        });
        return unadded.toArray(new IFile[unadded.size()]);
    }

    public AddWizard(AddOperation op, IFile[] unknowns) {
        super("AddWizard", CVSUIPlugin.getPlugin().getDialogSettings());
        this.op = op;
        this.unknowns = unknowns;
        this.setWindowTitle(CVSUIMessages.AddWizard_0);
        this.setDefaultPageImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
    }

    public void addPages() {
        HashSet names = new HashSet();
        HashSet extensions = new HashSet();
        AddWizard.getUnknownNamesAndExtension(this.unknowns, names, extensions);
        if (names.size() + extensions.size() > 0) {
            this.fFileTypePage = new CommitWizardFileTypePage(extensions, names);
            this.addPage((IWizardPage)this.fFileTypePage);
        }
        super.addPages();
    }

    private static void getUnknownNamesAndExtension(IFile[] files, Collection names, Collection extensions) {
        IFileContentManager manager = Team.getFileContentManager();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            String extension = file.getFileExtension();
            if (extension != null && !manager.isKnownExtension(extension)) {
                extensions.add(extension);
            }
            String name = file.getName();
            if (extension == null && name != null && !manager.isKnownFilename(name)) {
                names.add(name);
            }
            ++i;
        }
    }

    public boolean performFinish() {
        HashMap extensionsToSave = new HashMap();
        HashMap extensionsNotToSave = new HashMap();
        this.fFileTypePage.getModesForExtensions(extensionsToSave, extensionsNotToSave);
        CommitWizardFileTypePage.saveExtensionMappings(extensionsToSave);
        this.op.addModesForExtensions(extensionsNotToSave);
        HashMap namesToSave = new HashMap();
        HashMap namesNotToSave = new HashMap();
        this.fFileTypePage.getModesForNames(namesToSave, namesNotToSave);
        CommitWizardFileTypePage.saveNameMappings(namesToSave);
        this.op.addModesForNames(namesNotToSave);
        try {
            this.op.run();
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return super.performFinish();
    }
}

