/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ResourceMapping;
import org.eclipse.core.internal.resources.mapping.ResourceMappingContext;
import org.eclipse.core.internal.resources.mapping.ResourceTraversal;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.ui.PlatformUI;

public abstract class WorkspaceTraversalAction
extends WorkspaceAction {
    protected ResourceMapping[] getCVSResourceMappings() {
        return this.getSelectedResourceMappings(CVSProviderPlugin.getTypeId());
    }

    protected static IResource[] getRootTraversalResources(ResourceMapping[] mappings, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = mapping.getTraversals(context, monitor);
            int j = 0;
            while (j < traversals.length) {
                ResourceTraversal traversal = traversals[j];
                IResource[] resources = traversal.getResources();
                int k = 0;
                while (k < resources.length) {
                    IResource resource = resources[k];
                    if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) != null) {
                        result.add(resource);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected Subscriber getWorkspaceSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    protected IResource[] getResourcesToCompare(Subscriber subscriber) throws InvocationTargetException {
        return WorkspaceTraversalAction.getResourcesToCompare(this.getCVSResourceMappings(), subscriber);
    }

    public static IResource[] getResourcesToCompare(final ResourceMapping[] mappings, final Subscriber subscriber) throws InvocationTargetException {
        final IResource[][] resources = new IResource[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resources[0] = WorkspaceTraversalAction.getRootTraversalResources(mappings, SubscriberResourceMappingContext.getCompareContext((Subscriber)subscriber), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return resources[0];
    }

    public static IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            projects.add(resource.getProject());
            ++i;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    public static boolean isLogicalModel(ResourceMapping[] mappings) {
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            if (!(mapping.getModelObject() instanceof IResource)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

