/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class RemoteRevisionQuickDiffProvider
implements IQuickDiffReferenceProvider {
    private ITextEditor fEditor = null;
    private IDocument fReference = null;
    private boolean fReferenceInitialized = false;
    private IDocumentProvider fDocumentProvider = null;
    private String fId;
    private SyncInfo fLastSyncState;
    private Job fUpdateJob;
    private boolean DEBUG = false;
    private ISubscriberChangeListener teamChangeListener = new ISubscriberChangeListener(){

        public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
            if (RemoteRevisionQuickDiffProvider.this.fReferenceInitialized) {
                int i = 0;
                while (i < deltas.length) {
                    ISubscriberChangeEvent delta = deltas[i];
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && RemoteRevisionQuickDiffProvider.this.fLastSyncState != null && resource.equals((Object)RemoteRevisionQuickDiffProvider.this.fLastSyncState.getLocal()) && delta.getFlags() == 1) {
                        RemoteRevisionQuickDiffProvider.this.fetchContentsInJob();
                    }
                    ++i;
                }
            }
        }
    };
    private IElementStateListener documentListener = new IElementStateListener(){

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (RemoteRevisionQuickDiffProvider.this.fEditor != null && RemoteRevisionQuickDiffProvider.this.fEditor.getEditorInput() == element) {
                RemoteRevisionQuickDiffProvider.this.fetchContentsInJob();
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    };

    public IDocument getReference(IProgressMonitor monitor) throws CoreException {
        if (!this.fReferenceInitialized) {
            return null;
        }
        if (this.fReference == null) {
            this.readDocument(monitor);
        }
        return this.fReference;
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        IEditorInput editorInput = targetEditor.getEditorInput();
        if (editorInput == null || ResourceUtil.getFile((IEditorInput)editorInput) == null) {
            return;
        }
        this.fEditor = targetEditor;
        this.fDocumentProvider = this.fEditor.getDocumentProvider();
        if (this.fDocumentProvider != null) {
            CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().addListener(this.teamChangeListener);
            this.fDocumentProvider.addElementStateListener(this.documentListener);
        }
        this.fReferenceInitialized = true;
    }

    public boolean isEnabled() {
        if (!this.fReferenceInitialized) {
            return false;
        }
        try {
            return this.getManagedCVSFile() != null;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public void dispose() {
        this.fReferenceInitialized = false;
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.removeElementStateListener(this.documentListener);
        }
        CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().removeListener(this.teamChangeListener);
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    private boolean computeChange(IProgressMonitor monitor) throws TeamException {
        boolean needToUpdateReferenceDocument = false;
        if (this.fReferenceInitialized) {
            SyncInfo info = this.getSyncState((IResource)this.getFileFromEditor());
            if (info == null && this.fLastSyncState != null) {
                return true;
            }
            if (info == null) {
                return false;
            }
            if (this.fLastSyncState == null) {
                needToUpdateReferenceDocument = true;
            } else if (!this.fLastSyncState.equals((Object)info)) {
                needToUpdateReferenceDocument = true;
            }
            if (this.DEBUG) {
                this.debug(this.fLastSyncState, info);
            }
            this.fLastSyncState = info;
        }
        return needToUpdateReferenceDocument;
    }

    private void debug(SyncInfo lastSyncState, SyncInfo info) {
        String last = "[none]";
        if (lastSyncState != null) {
            last = lastSyncState.toString();
        }
        System.out.println("+ CVSQuickDiff: was " + last + " is " + info.toString());
    }

    private SyncInfo getSyncState(IResource resource) throws TeamException {
        if (resource == null) {
            return null;
        }
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getSyncInfo(resource);
    }

    private void readDocument(IProgressMonitor monitor) throws CoreException {
        if (!this.fReferenceInitialized) {
            return;
        }
        if (this.fReference == null) {
            this.fReference = new Document();
        }
        if (this.computeChange(monitor)) {
            ICVSRemoteFile remoteFile = (ICVSRemoteFile)this.fLastSyncState.getRemote();
            if (this.fLastSyncState.getRemote() != null && this.fDocumentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.fDocumentProvider;
                String encoding = provider.getEncoding((Object)this.fEditor.getEditorInput());
                if (encoding == null) {
                    encoding = provider.getDefaultEncoding();
                }
                if (monitor.isCanceled()) {
                    return;
                }
                InputStream stream = remoteFile.getContents(monitor);
                if (stream == null || monitor.isCanceled() || !this.fReferenceInitialized) {
                    return;
                }
                RemoteRevisionQuickDiffProvider.setDocumentContent(this.fReference, stream, encoding);
            } else {
                if (monitor.isCanceled()) {
                    return;
                }
                this.fReference.set("");
            }
            if (this.DEBUG) {
                System.out.println("+ CVSQuickDiff: updating document " + (this.fReference != null ? "remote found" : "remote empty"));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 142->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ICVSFile getManagedCVSFile() throws CVSException {
        IFile file;
        if (this.fEditor != null && (file = this.getFileFromEditor()) != null && CVSWorkspaceRoot.isSharedWithCVS((IResource)file)) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        }
        return null;
    }

    private IFile getFileFromEditor() {
        IEditorInput input;
        if (this.fEditor != null && (input = this.fEditor.getEditorInput()) != null) {
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            return file;
        }
        return null;
    }

    private void fetchContentsInJob() {
        if (!this.fReferenceInitialized) {
            return;
        }
        if (this.fUpdateJob != null && this.fUpdateJob.getState() != 0) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new Job(CVSUIMessages.RemoteRevisionQuickDiffProvider_fetchingFile){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    RemoteRevisionQuickDiffProvider.this.readDocument(monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        this.fUpdateJob.schedule();
    }
}

