/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public final class CVSResourceTransfer
extends ByteArrayTransfer {
    public static final String TYPE_NAME = "CVS-resource-transfer-format";
    public static int TYPE = CVSResourceTransfer.registerType((String)"CVS-resource-transfer-format");
    private static CVSResourceTransfer instance = new CVSResourceTransfer();

    private CVSResourceTransfer() {
    }

    public static CVSResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] bytes;
        if (!this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        if ((bytes = this.toByteArray((ICVSRemoteFile)object)) != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return this.fromByteArray(bytes);
    }

    private Object fromByteArray(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            String location = in.readUTF();
            String filePath = in.readUTF();
            String fileRevision = in.readUTF();
            ICVSRepositoryLocation repositoryLocation = KnownRepositories.getInstance().getRepository(location);
            RemoteFile file = RemoteFile.create((String)filePath, (ICVSRepositoryLocation)repositoryLocation);
            file.setRevision(fileRevision);
            file.setReadOnly(true);
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] toByteArray(ICVSRemoteFile file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeUTF(file.getRepository().getLocation(false));
            dos.writeUTF(file.getRepositoryRelativePath());
            dos.writeUTF(file.getRevision());
            return bos.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

