/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

public class DefaultChangeElement
extends ChangeElement {
    private Change fChange;
    private ChangeElement[] fChildren;

    public DefaultChangeElement(ChangeElement parent, Change change) {
        super(parent);
        this.fChange = change;
        Assert.isNotNull((Object)this.fChange);
    }

    public Change getChange() {
        return this.fChange;
    }

    public Object getModifiedElement() {
        return this.fChange;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        return ChangePreviewViewerDescriptor.get(this.fChange);
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        viewer.setInput(new ChangePreviewViewerInput(this.fChange));
    }

    public void setEnabled(boolean enabled) {
        this.fChange.setEnabled(enabled);
    }

    public void setEnabledShallow(boolean enabled) {
        this.fChange.setEnabledShallow(enabled);
    }

    public int getActive() {
        if (this.fChange instanceof CompositeChange || this.fChange instanceof TextChange) {
            return this.getCompositeChangeActive();
        }
        return this.getDefaultChangeActive();
    }

    public ChangeElement[] getChildren() {
        return this.fChildren;
    }

    public void setChildren(ChangeElement[] children) {
        Assert.isNotNull((Object)children);
        this.fChildren = children;
    }

    private int getDefaultChangeActive() {
        int result;
        int n = result = this.fChange.isEnabled() ? 2 : 0;
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
        }
        return result;
    }

    private int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int result = this.fChildren[0].getActive();
            int i = 1;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
            return result;
        }
        return 2;
    }
}

