/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.IChangeElementChildrenCreator;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangeElement;

class ChangeElementContentProvider
implements ITreeContentProvider {
    private static final ChangeElement[] EMPTY_CHILDREN = new ChangeElement[0];
    static /* synthetic */ Class class$0;

    ChangeElementContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object o) {
        ChangeElement element = (ChangeElement)o;
        Object[] children = element.getChildren();
        if (children == null) {
            children = this.createChildren(element);
        }
        return children;
    }

    public Object getParent(Object element) {
        return ((ChangeElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    private ChangeElement[] createChildren(ChangeElement object) {
        ChangeElement[] result = EMPTY_CHILDREN;
        if (!(object instanceof DefaultChangeElement)) {
            return result;
        }
        DefaultChangeElement changeElement = (DefaultChangeElement)object;
        Change change = changeElement.getChange();
        if (change instanceof CompositeChange) {
            ArrayList children = new ArrayList();
            this.getFlattendedChildren(children, changeElement, (CompositeChange)change);
            result = children.toArray(new ChangeElement[children.size()]);
            changeElement.setChildren(result);
        } else {
            IChangeElementChildrenCreator creator;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.internal.ui.refactoring.IChangeElementChildrenCreator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((creator = (IChangeElementChildrenCreator)change.getAdapter((Class)clazz)) != null) {
                creator.createChildren(changeElement);
                result = changeElement.getChildren();
            } else if (change instanceof TextChange) {
                TextEditChangeGroup[] changes = this.getSortedTextEditChanges((TextChange)change);
                result = new ChangeElement[changes.length];
                int i = 0;
                while (i < changes.length) {
                    result[i] = new TextEditChangeElement(changeElement, changes[i]);
                    ++i;
                }
                changeElement.setChildren(result);
            }
        }
        return result;
    }

    private TextEditChangeGroup[] getSortedTextEditChanges(TextChange change) {
        TextEditChangeGroup[] edits = change.getTextEditChangeGroups();
        ArrayList<TextEditChangeGroup> result = new ArrayList<TextEditChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditChangeGroup[result.size()]);
    }

    private void getFlattendedChildren(List result, DefaultChangeElement parent, CompositeChange focus) {
        Change[] changes = focus.getChildren();
        int i = 0;
        while (i < changes.length) {
            Change change = changes[i];
            if (change instanceof CompositeChange && ((CompositeChange)change).isSynthetic()) {
                this.getFlattendedChildren(result, parent, (CompositeChange)change);
            } else {
                result.add(new DefaultChangeElement(parent, change));
            }
            ++i;
        }
    }

    private static class OffsetComparator
    implements Comparator {
        OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditChangeGroup c1 = (TextEditChangeGroup)o1;
            TextEditChangeGroup c2 = (TextEditChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

