/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchConfigurationWorkingCopy
extends LaunchConfiguration
implements ILaunchConfigurationWorkingCopy {
    private LaunchConfiguration fOriginal;
    private LaunchConfigurationInfo fInfo;
    private boolean fDirty = false;
    private String fName;
    private boolean fRenamed = false;
    private boolean fSuppressChange = true;
    private IContainer fContainer;

    protected LaunchConfigurationWorkingCopy(LaunchConfiguration original) throws CoreException {
        super(original.getLocation());
        this.setName(original.getName());
        this.copyFrom(original);
        this.setOriginal(original);
        this.fSuppressChange = false;
    }

    protected LaunchConfigurationWorkingCopy(LaunchConfiguration original, String name) throws CoreException {
        super(original.getLocation());
        this.copyFrom(original);
        this.setName(name);
        this.fSuppressChange = false;
    }

    protected LaunchConfigurationWorkingCopy(IContainer container, String name, ILaunchConfigurationType type) {
        super((IPath)null);
        this.setName(name);
        this.setInfo(new LaunchConfigurationInfo());
        this.getInfo().setType(type);
        this.setContainer(container);
        this.fSuppressChange = false;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public ILaunchConfiguration doSave() throws CoreException {
        if (this.isDirty()) {
            boolean useRunnable = true;
            if (this.isLocal()) {
                useRunnable = this.isMoved() ? !this.isNew() && !this.getOriginal().isLocal() : false;
            }
            if (useRunnable) {
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor pm) throws CoreException {
                        LaunchConfigurationWorkingCopy.this.doSave0();
                    }
                };
                ResourcesPlugin.getWorkspace().run(wr, this.getSchedulingRule(), 0, null);
            } else {
                this.doSave0();
            }
            this.getLaunchManager().setMovedFromTo(null, null);
        }
        return new LaunchConfiguration(this.getLocation());
    }

    private ISchedulingRule getSchedulingRule() {
        IFile[] files;
        IFile[] files2;
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>(2);
        IResourceRuleFactory fac = ResourcesPlugin.getWorkspace().getRuleFactory();
        if (!this.isLocal() && (files2 = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(this.getLocation())).length > 0) {
            IFile file = files2[0];
            ISchedulingRule rule = null;
            rule = file.exists() ? fac.modifyRule((IResource)file) : fac.createRule((IResource)file);
            rules.add(MultiRule.combine((ISchedulingRule)rule, (ISchedulingRule)fac.validateEditRule((IResource[])files2)));
        }
        ILaunchConfiguration original = this.getOriginal();
        if (!this.isNew() && this.isMoved() && !original.isLocal() && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(original.getLocation())).length > 0) {
            rules.add(MultiRule.combine((ISchedulingRule)fac.deleteRule((IResource)files[0]), (ISchedulingRule)fac.validateEditRule((IResource[])files)));
        }
        if (rules.isEmpty()) {
            return null;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private void doSave0() throws CoreException {
        boolean moved;
        boolean bl = moved = !this.isNew() && this.isMoved();
        if (moved) {
            LaunchConfiguration to = new LaunchConfiguration(this.getLocation());
            ILaunchConfiguration from = this.getOriginal();
            this.getLaunchManager().setMovedFromTo(from, to);
        }
        if (moved) {
            this.getOriginal().delete();
        }
        this.writeNewFile();
        this.resetDirty();
    }

    protected void writeNewFile() throws CoreException {
        String xml = null;
        Exception e = null;
        try {
            xml = this.getInfo().getAsXML();
        }
        catch (IOException ioe) {
            e = ioe;
        }
        catch (ParserConfigurationException pce) {
            e = pce;
        }
        catch (TransformerException te) {
            e = te;
        }
        if (e != null) {
            throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.LaunchConfigurationWorkingCopy__0__occurred_generating_launch_configuration_XML__1, e.toString()), null));
        }
        if (this.isLocal()) {
            try {
                boolean added = false;
                File file = this.getLocation().toFile();
                File dir = this.getLocation().removeLastSegments(1).toFile();
                dir.mkdirs();
                if (!file.exists()) {
                    added = true;
                    file.createNewFile();
                }
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(xml.getBytes("UTF8"));
                stream.close();
                if (added) {
                    this.getLaunchManager().launchConfigurationAdded(new LaunchConfiguration(this.getLocation()));
                }
                this.getLaunchManager().launchConfigurationChanged(new LaunchConfiguration(this.getLocation()));
            }
            catch (IOException ie) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, MessageFormat.format(DebugCoreMessages.LaunchConfigurationWorkingCopy__0__occurred_generating_launch_configuration_XML__1, ie.toString()), null));
            }
        } else {
            IFile file = this.getFile();
            IContainer dir = file.getParent();
            if (!dir.exists()) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationWorkingCopy_Specified_container_for_launch_configuration_does_not_exist_2, null));
            }
            ByteArrayInputStream stream = null;
            try {
                stream = new ByteArrayInputStream(xml.getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.LaunchConfigurationWorkingCopy_5, null));
            }
            if (!file.exists()) {
                file.create((InputStream)stream, false, null);
            } else {
                IStatus status;
                if (file.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
                    throw new CoreException(status);
                }
                file.setContents((InputStream)stream, false, false, null);
            }
        }
    }

    public void setAttribute(String attributeName, int value) {
        this.getInfo().setAttribute(attributeName, new Integer(value));
        this.setDirty();
    }

    public void setAttribute(String attributeName, String value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, boolean value) {
        this.getInfo().setAttribute(attributeName, new Boolean(value));
        this.setDirty();
    }

    public void setAttribute(String attributeName, List value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public void setAttribute(String attributeName, Map value) {
        this.getInfo().setAttribute(attributeName, value);
        this.setDirty();
    }

    public ILaunchConfiguration getOriginal() {
        return this.fOriginal;
    }

    private void copyFrom(LaunchConfiguration original) throws CoreException {
        LaunchConfigurationInfo info = original.getInfo();
        this.setInfo(info.getCopy());
        this.setContainer(original.getContainer());
        this.resetDirty();
    }

    private void setOriginal(LaunchConfiguration original) {
        this.fOriginal = original;
    }

    protected void setInfo(LaunchConfigurationInfo info) {
        this.fInfo = info;
    }

    public boolean isWorkingCopy() {
        return true;
    }

    protected LaunchConfigurationInfo getInfo() {
        return this.fInfo;
    }

    private void setDirty() {
        this.fDirty = true;
        if (!this.suppressChangeNotification()) {
            this.getLaunchManager().getConfigurationNotifier().notify(this, 2);
        }
    }

    private void resetDirty() {
        this.fDirty = false;
    }

    public void rename(String name) {
        if (!this.getName().equals(name)) {
            this.setName(name);
            this.fRenamed = this.isNew() || !this.getOriginal().getName().equals(name);
        }
    }

    private void setName(String name) {
        this.fName = name;
        this.setDirty();
    }

    public String getName() {
        return this.fName;
    }

    public boolean isLocal() {
        return this.getContainer() == null;
    }

    public IPath getLocation() {
        if (this.isMoved()) {
            IPath path = null;
            path = this.isLocal() ? LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH : this.getContainer().getLocation();
            path = path.append(String.valueOf(this.getName()) + "." + "launch");
            return path;
        }
        return this.getOriginal().getLocation();
    }

    protected boolean isNew() {
        return this.getOriginal() == null;
    }

    protected boolean isMoved() {
        IContainer originalContainer;
        if (this.isNew() || this.fRenamed) {
            return true;
        }
        IContainer newContainer = this.getContainer();
        if (newContainer == (originalContainer = ((LaunchConfiguration)this.getOriginal()).getContainer())) {
            return false;
        }
        if (newContainer == null) {
            return !originalContainer.equals((Object)newContainer);
        }
        return !newContainer.equals((Object)originalContainer);
    }

    public String getMemento() {
        return null;
    }

    protected boolean suppressChangeNotification() {
        return this.fSuppressChange;
    }

    public void setContainer(IContainer container) {
        if (container == this.fContainer) {
            return;
        }
        if (container != null ? container.equals((Object)this.fContainer) : this.fContainer.equals((Object)container)) {
            return;
        }
        this.fContainer = container;
        this.setDirty();
    }

    protected IContainer getContainer() {
        return this.fContainer;
    }

    public void setAttributes(Map attributes) {
        this.getInfo().setAttributes(attributes);
    }
}

