/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.internal.core.sourcelookup.containers.ContainerSourceContainer;

public class ProjectSourceContainer
extends ContainerSourceContainer {
    boolean fReferencedProjects = false;
    public static final String TYPE_ID = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".containerType.project";

    public ProjectSourceContainer(IProject project, boolean referenced) {
        super((IContainer)project, true);
        this.fReferencedProjects = referenced;
    }

    public boolean isSearchReferencedProjects() {
        return this.fReferencedProjects;
    }

    public IProject getProject() {
        return (IProject)this.getContainer();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean isComposite() {
        return true;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.getProject().isOpen()) {
            if (this.isSearchReferencedProjects()) {
                IProject project = this.getProject();
                IProject[] projects = project.getReferencedProjects();
                ISourceContainer[] folders = super.createSourceContainers();
                ArrayList<ISourceContainer> all = new ArrayList<ISourceContainer>(folders.length + projects.length);
                int i = 0;
                while (i < folders.length) {
                    all.add(folders[i]);
                    ++i;
                }
                i = 0;
                while (i < projects.length) {
                    if (project.exists() && project.isOpen()) {
                        ProjectSourceContainer container = new ProjectSourceContainer(projects[i], true);
                        container.init(this.getDirector());
                        all.add(container);
                    }
                    ++i;
                }
                return all.toArray(new ISourceContainer[all.size()]);
            }
            return super.createSourceContainers();
        }
        return new ISourceContainer[0];
    }
}

