/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.builders;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerFlags {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int IGNORE = 2;
    public static final int MARKER = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING = 2;
    public static final int PLUGIN_FLAGS = 0;
    public static final int SCHEMA_FLAGS = 1;
    public static final int FEATURE_FLAGS = 2;
    public static final int SITE_FLAGS = 3;
    public static final String USE_PROJECT_PREF = "compilers.use-project";
    public static final String P_UNRESOLVED_IMPORTS = "compilers.p.unresolved-import";
    public static final String P_UNRESOLVED_EX_POINTS = "compilers.p.unresolved-ex-points";
    public static final String P_UNKNOWN_ELEMENT = "compilers.p.unknown-element";
    public static final String P_UNKNOWN_ATTRIBUTE = "compilers.p.unknown-attribute";
    public static final String P_UNKNOWN_CLASS = "compilers.p.unknown-class";
    public static final String P_UNKNOWN_RESOURCE = "compilers.p.unknown-resource";
    public static final String P_NO_REQUIRED_ATT = "compilers.p.no-required-att";
    public static final String P_NOT_EXTERNALIZED = "compilers.p.not-externalized-att";
    public static final String P_DEPRECATED = "compilers.p.deprecated";
    public static final String S_CREATE_DOCS = "compilers.s.create-docs";
    public static final String S_DOC_FOLDER = "compilers.s.doc-folder";
    public static final String S_OPEN_TAGS = "compilers.s.open-tags";
    public static final String F_UNRESOLVED_PLUGINS = "compilers.f.unresolved-plugins";
    public static final String F_UNRESOLVED_FEATURES = "compilers.f.unresolved-features";
    private static final String[][] fFlags = new String[][]{{"compilers.p.unresolved-import", "compilers.p.unresolved-ex-points", "compilers.p.no-required-att", "compilers.p.unknown-element", "compilers.p.unknown-attribute", "compilers.p.deprecated", "compilers.p.unknown-class", "compilers.p.unknown-resource", "compilers.p.not-externalized-att"}, {"compilers.s.create-docs", "compilers.s.doc-folder", "compilers.s.open-tags"}, {"compilers.f.unresolved-plugins", "compilers.f.unresolved-features"}, new String[0]};

    public static int getFlagType(String flagId) {
        if (flagId.equals(S_CREATE_DOCS)) {
            return 1;
        }
        if (flagId.equals(S_DOC_FOLDER)) {
            return 2;
        }
        return 0;
    }

    public static int getFlag(IProject project, String flagId) {
        try {
            return Integer.parseInt(CompilerFlags.getString(project, flagId));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static boolean getBoolean(IProject project, String flagId) {
        return Boolean.valueOf(CompilerFlags.getString(project, flagId));
    }

    public static String getString(IProject project, String flagId) {
        IScopeContext[] iScopeContextArray;
        IPreferencesService service = Platform.getPreferencesService();
        if (project == null) {
            iScopeContextArray = null;
        } else {
            IScopeContext[] iScopeContextArray2 = new IScopeContext[1];
            iScopeContextArray = iScopeContextArray2;
            iScopeContextArray2[0] = new ProjectScope(project);
        }
        IScopeContext[] contexts = iScopeContextArray;
        return service.getString("org.eclipse.pde", flagId, "", project == null ? null : contexts);
    }

    public static int getDefaultFlag(String flagId) {
        return new DefaultScope().getNode("org.eclipse.pde").getInt(flagId, 0);
    }

    public static String getDefaultString(String flagId) {
        return new DefaultScope().getNode("org.eclipse.pde").get(flagId, "");
    }

    public static boolean getDefaultBoolean(String flagId) {
        return new DefaultScope().getNode("org.eclipse.pde").getBoolean(flagId, false);
    }

    public static void setFlag(String flagId, int value) {
        if (CompilerFlags.getDefaultFlag(flagId) == value) {
            new InstanceScope().getNode("org.eclipse.pde").remove(flagId);
        } else {
            new InstanceScope().getNode("org.eclipse.pde").putInt(flagId, value);
        }
    }

    public static void setFlag(IProject project, String flagId, int value) {
        CompilerFlags.setString(project, flagId, Integer.toString(value));
    }

    public static void setBoolean(String flagId, boolean value) {
        if (CompilerFlags.getDefaultBoolean(flagId) == value) {
            new InstanceScope().getNode("org.eclipse.pde").remove(flagId);
        } else {
            new InstanceScope().getNode("org.eclipse.pde").putBoolean(flagId, value);
        }
    }

    public static void setBoolean(IProject project, String flagId, boolean value) {
        CompilerFlags.setString(project, flagId, Boolean.toString(value));
    }

    public static void setString(String flagId, String value) {
        if (CompilerFlags.getDefaultString(flagId).equals(value)) {
            new InstanceScope().getNode("org.eclipse.pde").remove(flagId);
        } else {
            new InstanceScope().getNode("org.eclipse.pde").put(flagId, value);
        }
    }

    public static void setString(IProject project, String flagId, String value) {
        if (project == null) {
            return;
        }
        IEclipsePreferences preferences = new ProjectScope(project).getNode("org.eclipse.pde");
        preferences.put(flagId, value);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void clear(IProject project, String flagId) {
        if (project == null) {
            return;
        }
        IEclipsePreferences preferences = new ProjectScope(project).getNode("org.eclipse.pde");
        preferences.remove(flagId);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void initializeDefaults() {
        IEclipsePreferences node = new DefaultScope().getNode("org.eclipse.pde");
        node.putInt(P_UNRESOLVED_IMPORTS, 0);
        node.putInt(P_UNRESOLVED_EX_POINTS, 0);
        node.putInt(P_NO_REQUIRED_ATT, 0);
        node.putInt(P_UNKNOWN_ELEMENT, 1);
        node.putInt(P_UNKNOWN_ATTRIBUTE, 0);
        node.putInt(P_UNKNOWN_CLASS, 2);
        node.putInt(P_UNKNOWN_RESOURCE, 2);
        node.putInt(P_NOT_EXTERNALIZED, 2);
        node.putInt(P_DEPRECATED, 1);
        node.putBoolean(S_CREATE_DOCS, false);
        node.put(S_DOC_FOLDER, "doc");
        node.putInt(S_OPEN_TAGS, 1);
        node.putInt(F_UNRESOLVED_PLUGINS, 1);
        node.putInt(F_UNRESOLVED_FEATURES, 1);
    }

    public static String[] getFlags(int group) {
        return fFlags[group];
    }

    public static void save() {
        try {
            new InstanceScope().getNode("org.eclipse.pde").flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }
}

