/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class StandardClasspathProvider
implements IRuntimeClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IJavaProject proj = JavaRuntime.getJavaProject(configuration);
            if (proj == null) {
                return new IRuntimeClasspathEntry[]{this.computeJRELibraryEntry(configuration)};
            }
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(proj);
            IVMInstall projJRE = JavaRuntime.getVMInstall(proj);
            IVMInstall configJRE = JavaRuntime.computeVMInstall(configuration);
            if (configJRE.equals(projJRE)) {
                return entries;
            }
            int i = 0;
            while (i < entries.length) {
                IRuntimeClasspathEntry entry = entries[i];
                switch (entry.getType()) {
                    case 4: {
                        if (entry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                            entries[i] = this.computeJRELibraryEntry(configuration);
                            return entries;
                        }
                    }
                    case 3: {
                        if (!entry.getPath().segment(0).equals("JRE_LIB")) break;
                        entries[i] = this.computeJRELibraryEntry(configuration);
                        return entries;
                    }
                }
                ++i;
            }
            return entries;
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    private IRuntimeClasspathEntry computeJRELibraryEntry(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall vm = JavaRuntime.computeVMInstall(configuration);
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        path = path.append(vm.getVMInstallType().getId()).append(vm.getName());
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)path, 1);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry(entries[i], configuration);
            int j = 0;
            while (j < resolved.length) {
                all.add(resolved[j]);
                ++j;
            }
            ++i;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    protected IRuntimeClasspathEntry[] recoverRuntimePath(ILaunchConfiguration configuration, String attribute) throws CoreException {
        List entries = configuration.getAttribute(attribute, Collections.EMPTY_LIST);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = JavaRuntime.newRuntimeClasspathEntry((String)iter.next());
            ++i;
        }
        return rtes;
    }
}

