/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.WorkingSetComparator;
import org.eclipse.search.internal.ui.util.PixelConverter;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class ScopePart {
    private static final String DIALOG_SETTINGS_KEY = "SearchDialog.ScopePart";
    private static final String STORE_SCOPE = "scope";
    private static final String STORE_LRU_WORKING_SET_NAME = "lastUsedWorkingSetName";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private IDialogSettings fSettingsStore;
    private Group fPart;
    private Button fUseWorkspace;
    private Button fUseSelection;
    private Button fUseProject;
    private Button fUseWorkingSet;
    private int fScope;
    private boolean fCanSearchEnclosingProjects;
    private Text fWorkingSetText;
    private IWorkingSet[] fWorkingSets;
    private SearchDialog fSearchDialog;

    public ScopePart(SearchDialog searchDialog, boolean searchEnclosingProjects) {
        int initialScope;
        IDialogSettings dialogSettings = SearchPlugin.getDefault().getDialogSettings();
        this.fSettingsStore = dialogSettings.getSection(DIALOG_SETTINGS_KEY);
        if (this.fSettingsStore == null) {
            this.fSettingsStore = dialogSettings.addNewSection(DIALOG_SETTINGS_KEY);
        }
        Assert.isLegal(((initialScope = this.getStoredScope(this.fSettingsStore)) >= 0 && initialScope <= 3 ? 1 : 0) != 0);
        this.fScope = initialScope;
        this.fCanSearchEnclosingProjects = searchEnclosingProjects;
        if (!this.fCanSearchEnclosingProjects && this.fScope == 3) {
            this.fScope = 0;
        }
        this.fSearchDialog = searchDialog;
        this.restoreState();
    }

    private int getStoredScope(IDialogSettings settingsStore) {
        int scope;
        try {
            scope = settingsStore.getInt(STORE_SCOPE);
        }
        catch (NumberFormatException numberFormatException) {
            scope = 0;
        }
        if (scope != 2 && scope != 1 && scope != 3 && scope != 0) {
            scope = 0;
        }
        return scope;
    }

    private void restoreState() {
        String[] lruWorkingSetNames = this.fSettingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        if (lruWorkingSetNames != null) {
            HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(lruWorkingSetNames.length);
            int i = 0;
            while (i < lruWorkingSetNames.length) {
                String name = lruWorkingSetNames[i];
                IWorkingSet workingSet = workingSetManager.getWorkingSet(name);
                if (workingSet != null) {
                    existingWorkingSets.add(workingSet);
                }
                ++i;
            }
            if (!existingWorkingSets.isEmpty()) {
                this.fWorkingSets = existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
            }
        } else {
            IWorkingSet workingSet;
            String workingSetName = this.fSettingsStore.get(STORE_LRU_WORKING_SET_NAME);
            if (workingSetName != null && (workingSet = workingSetManager.getWorkingSet(workingSetName)) != null) {
                this.fWorkingSets = new IWorkingSet[]{workingSet};
                this.saveState();
            }
        }
    }

    public int getSelectedScope() {
        return this.fScope;
    }

    public void setSelectedScope(int scope) {
        Assert.isLegal((scope >= 0 && scope <= 3 ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.fUseWorkspace);
        Assert.isNotNull((Object)this.fUseSelection);
        Assert.isNotNull((Object)this.fUseWorkingSet);
        Assert.isNotNull((Object)this.fUseProject);
        if (scope == 3) {
            if (!this.fCanSearchEnclosingProjects) {
                SearchPlugin.log((IStatus)new Status(2, "org.eclipse.search", 2, "Enclosing projects scope set on search page that does not support it", null));
                scope = 0;
            } else if (!this.fUseProject.isEnabled()) {
                scope = 0;
            }
        } else if (scope == 1 && !this.fUseSelection.isEnabled()) {
            scope = 0;
        }
        this.fScope = scope;
        this.fUseWorkspace.setSelection(scope == 0);
        this.fUseSelection.setSelection(scope == 1);
        this.fUseProject.setSelection(scope == 3);
        this.fUseWorkingSet.setSelection(scope == 2);
        this.updateSearchPageContainerActionPerformedEnablement();
        this.fSettingsStore.put(STORE_SCOPE, scope);
    }

    private void updateSearchPageContainerActionPerformedEnablement() {
        this.fSearchDialog.notifyScopeSelectionChanged();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.getSelectedScope() == 2) {
            return this.fWorkingSets;
        }
        return null;
    }

    public void setSelectedWorkingSets(IWorkingSet[] workingSets) {
        Assert.isNotNull((Object)workingSets);
        this.setSelectedScope(2);
        this.fWorkingSets = null;
        HashSet<IWorkingSet> existingWorkingSets = new HashSet<IWorkingSet>(workingSets.length);
        int i = 0;
        while (i < workingSets.length) {
            String name = workingSets[i].getName();
            IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
            if (workingSet != null) {
                existingWorkingSets.add(workingSet);
            }
            ++i;
        }
        if (!existingWorkingSets.isEmpty()) {
            this.fWorkingSets = existingWorkingSets.toArray(new IWorkingSet[existingWorkingSets.size()]);
        }
        this.saveState();
        if (this.fWorkingSetText != null) {
            this.fWorkingSetText.setText(ScopePart.toString(this.fWorkingSets));
        }
    }

    private void saveState() {
        if (this.fWorkingSets != null && this.fWorkingSets.length > 0) {
            String[] existingWorkingSetNames = new String[this.fWorkingSets.length];
            int i = 0;
            while (i < existingWorkingSetNames.length) {
                existingWorkingSetNames[i] = this.fWorkingSets[i].getName();
                ++i;
            }
            this.fSettingsStore.put(STORE_LRU_WORKING_SET_NAMES, existingWorkingSetNames);
        }
    }

    public Composite createPart(Composite parent) {
        this.fPart = new Group(parent, 0);
        this.fPart.setText(SearchMessages.ScopePart_group_text);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.fPart.setLayout((Layout)layout);
        this.fPart.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button((Composite)this.fPart, 16);
        this.fUseWorkspace.setData((Object)new Integer(0));
        this.fUseWorkspace.setText(SearchMessages.ScopePart_workspaceScope_text);
        this.fUseSelection = new Button((Composite)this.fPart, 16);
        this.fUseSelection.setData((Object)new Integer(1));
        this.fUseSelection.setText(SearchMessages.ScopePart_selectedResourcesScope_text);
        ISelection selection = this.fSearchDialog.getSelection();
        this.fUseSelection.setEnabled(selection instanceof IStructuredSelection && !selection.isEmpty());
        GridData gd = new GridData(32);
        gd.horizontalIndent = 8;
        this.fUseSelection.setLayoutData((Object)gd);
        this.fUseProject = new Button((Composite)this.fPart, 16);
        this.fUseProject.setData((Object)new Integer(3));
        this.fUseProject.setText(SearchMessages.ScopePart_enclosingProjectsScope_text);
        this.fUseProject.setEnabled(selection instanceof IStructuredSelection && !selection.isEmpty() || this.hasFocusEditor());
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 8;
        this.fUseProject.setLayoutData((Object)gd);
        if (!this.fCanSearchEnclosingProjects) {
            this.fUseProject.setVisible(false);
        }
        this.fUseWorkingSet = new Button((Composite)this.fPart, 16);
        this.fUseWorkingSet.setData((Object)new Integer(2));
        this.fUseWorkingSet.setText(SearchMessages.ScopePart_workingSetScope_text);
        this.fWorkingSetText = new Text((Composite)this.fPart, 2060);
        this.fWorkingSetText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SearchMessages.ScopePart_workingSetText_accessible_label;
            }
        });
        Button chooseWorkingSet = new Button((Composite)this.fPart, 8);
        chooseWorkingSet.setLayoutData((Object)new GridData());
        chooseWorkingSet.setText(SearchMessages.ScopePart_workingSetChooseButton_text);
        SWTUtil.setButtonDimensionHint(chooseWorkingSet);
        chooseWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ScopePart.this.handleChooseWorkingSet()) {
                    ScopePart.this.setSelectedScope(2);
                }
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.horizontalSpan = 2;
        gd.widthHint = new PixelConverter((Control)this.fWorkingSetText).convertWidthInCharsToPixels(30);
        this.fWorkingSetText.setLayoutData((Object)gd);
        SelectionAdapter scopeChangedLister = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopePart.this.handleScopeChanged(e);
            }
        };
        this.fUseWorkspace.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseSelection.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseProject.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseWorkingSet.addSelectionListener((SelectionListener)scopeChangedLister);
        this.setSelectedScope(this.fScope);
        if (this.fWorkingSets != null) {
            this.fWorkingSetText.setText(ScopePart.toString(this.fWorkingSets));
        }
        return this.fPart;
    }

    private boolean hasFocusEditor() {
        IWorkbenchPage activePage = SearchPlugin.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage.getActivePart() instanceof IEditorPart;
    }

    private void handleScopeChanged(SelectionEvent e) {
        Button button;
        Object source = e.getSource();
        if (source instanceof Button && (button = (Button)source).getSelection()) {
            this.setSelectedScope((Integer)button.getData());
        }
    }

    private boolean handleChooseWorkingSet() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(this.fUseSelection.getShell(), true);
        if (this.fWorkingSets != null) {
            dialog.setSelection(this.fWorkingSets);
        }
        if (dialog.open() == 0) {
            IWorkingSet[] result = dialog.getSelection();
            if (result.length > 0) {
                this.setSelectedWorkingSets(result);
                return true;
            }
            this.fWorkingSetText.setText("");
            this.fWorkingSets = null;
            if (this.fScope == 2) {
                this.setSelectedScope(0);
            }
            return false;
        }
        if (this.fWorkingSets != null) {
            int i = 0;
            while (i < this.fWorkingSets.length) {
                if (workingSetManager.getWorkingSet(this.fWorkingSets[i].getName()) == null) break;
                ++i;
            }
            if (i < this.fWorkingSets.length) {
                this.fWorkingSetText.setText("");
                this.fWorkingSets = null;
                this.updateSearchPageContainerActionPerformedEnablement();
            }
        }
        return false;
    }

    void setVisible(boolean state) {
        this.fPart.setVisible(state);
    }

    public static String toString(IWorkingSet[] workingSets) {
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            Arrays.sort(workingSets, new WorkingSetComparator());
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetName = workingSets[i].getName();
                if (firstFound) {
                    result = Messages.format(SearchMessages.ScopePart_workingSetConcatenation, new String[]{result, workingSetName});
                } else {
                    result = workingSetName;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }
}

