/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.SearchMessages;

public class MatchLocator {
    private Matcher fMatcher;

    public MatchLocator(Pattern pattern) {
        this.fMatcher = pattern.matcher("");
    }

    public MatchLocator(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        this(PatternConstructor.createPattern(pattern, isCaseSensitive, isRegexSearch));
    }

    public boolean isEmpty() {
        return this.fMatcher.pattern().pattern().length() == 0;
    }

    public void locateMatches(IProgressMonitor progressMonitor, CharSequence searchInput, ITextSearchResultCollector collector, IResourceProxy proxy) throws CoreException {
        this.fMatcher.reset(searchInput);
        int k = 0;
        while (this.fMatcher.find()) {
            int start = this.fMatcher.start();
            int end = this.fMatcher.end();
            if (end != start) {
                collector.accept(proxy, start, end - start);
            }
            if (k++ != 20) continue;
            if (progressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
            }
            k = 0;
        }
    }
}

