/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.draw2d.internal.graph;

import org.eclipse.draw2d.graph.DirectedGraph;

/**
 * Performs some action on a Graph.
 * @author Randy Hudson
 * @since 2.1.2
 */
public abstract class GraphVisitor {

/**
 * Act on the given directed graph.
 * @param g the graph
 */
public abstract void visit(DirectedGraph g);

/**
 * Called in reverse order of visit.
 * @since 3.1
 * @param g the graph to act upon
 */
public void revisit(DirectedGraph g) { }

}
