/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

public abstract class PrintOperation {
    private GC printerGC;
    private Insets printMargin = new Insets(0, 0, 0, 0);
    private Printer printer;
    private PrinterGraphics printerGraphics;
    private SWTGraphics g;

    public PrintOperation() {
    }

    public PrintOperation(Printer p) {
        this.setPrinter(p);
    }

    protected void cleanup() {
        if (this.g != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
        }
        if (this.printerGC != null) {
            this.printerGC.dispose();
        }
    }

    protected PrinterGraphics getFreshPrinterGraphics() {
        if (this.printerGraphics != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
            this.printerGraphics = null;
            this.g = null;
        }
        this.g = new SWTGraphics(this.printerGC);
        this.printerGraphics = new PrinterGraphics(this.g, this.printer);
        this.setupGraphicsForPage(this.printerGraphics);
        return this.printerGraphics;
    }

    int getGraphicsOrientation() {
        return 0x2000000;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public Rectangle getPrintRegion() {
        org.eclipse.swt.graphics.Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        org.eclipse.swt.graphics.Rectangle clientArea = this.printer.getClientArea();
        Point printerDPI = this.printer.getDPI();
        Rectangle printRegion = new Rectangle();
        printRegion.x = Math.max(this.printMargin.left * printerDPI.x / 72 - trim.width, clientArea.x);
        printRegion.y = Math.max(this.printMargin.top * printerDPI.y / 72 - trim.height, clientArea.y);
        printRegion.width = clientArea.x + clientArea.width - printRegion.x - Math.max(0, this.printMargin.right * printerDPI.x / 72 - trim.width);
        printRegion.height = clientArea.y + clientArea.height - printRegion.y - Math.max(0, this.printMargin.bottom * printerDPI.y / 72 - trim.height);
        return printRegion;
    }

    protected void preparePrintSource() {
    }

    protected abstract void printPages();

    protected void restorePrintSource() {
    }

    public void run(String jobName) {
        this.preparePrintSource();
        if (this.printer.startJob(jobName)) {
            this.printerGC = new GC((Drawable)this.getPrinter(), this.getGraphicsOrientation());
            this.printPages();
            this.printer.endJob();
        }
        this.restorePrintSource();
        this.cleanup();
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setPrintMargin(Insets margin) {
        this.printMargin = margin;
    }

    protected void setupGraphicsForPage(PrinterGraphics pg) {
        Rectangle printRegion = this.getPrintRegion();
        pg.clipRect(printRegion);
        pg.translate(printRegion.getTopLeft());
    }
}

