/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDConstants {
    public static final String PART1 = "http://www.w3.org/TR/xmlschema-1/";
    public static final String PART2 = "http://www.w3.org/TR/xmlschema-2/";
    public static final String XML_NAMESPACE_URI_1998 = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_URI_2000 = "http://www.w3.org/2000/xmlns/";
    public static final String SCHEMA_FOR_SCHEMA_URI_1999 = "http://www.w3.org/1999/XMLSchema";
    public static final String SCHEMA_FOR_SCHEMA_URI_2000_10 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String SCHEMA_FOR_SCHEMA_URI_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_INSTANCE_URI_2001 = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String ALL_ELEMENT_TAG = "all";
    public static final String ANNOTATION_ELEMENT_TAG = "annotation";
    public static final String ANY_ELEMENT_TAG = "any";
    public static final String ANYATTRIBUTE_ELEMENT_TAG = "anyAttribute";
    public static final String APPINFO_ELEMENT_TAG = "appinfo";
    public static final String ATTRIBUTE_ELEMENT_TAG = "attribute";
    public static final String ATTRIBUTEGROUP_ELEMENT_TAG = "attributeGroup";
    public static final String CHOICE_ELEMENT_TAG = "choice";
    public static final String COMPLEXCONTENT_ELEMENT_TAG = "complexContent";
    public static final String COMPLEXTYPE_ELEMENT_TAG = "complexType";
    public static final String DOCUMENTATION_ELEMENT_TAG = "documentation";
    public static final String ELEMENT_ELEMENT_TAG = "element";
    public static final String ENUMERATION_ELEMENT_TAG = "enumeration";
    public static final String EXTENSION_ELEMENT_TAG = "extension";
    public static final String FIELD_ELEMENT_TAG = "field";
    public static final String FRACTIONDIGITS_ELEMENT_TAG = "fractionDigits";
    public static final String GROUP_ELEMENT_TAG = "group";
    public static final String IMPORT_ELEMENT_TAG = "import";
    public static final String INCLUDE_ELEMENT_TAG = "include";
    public static final String KEY_ELEMENT_TAG = "key";
    public static final String KEYREF_ELEMENT_TAG = "keyref";
    public static final String LENGTH_ELEMENT_TAG = "length";
    public static final String LIST_ELEMENT_TAG = "list";
    public static final String MAXEXCLUSIVE_ELEMENT_TAG = "maxExclusive";
    public static final String MAXINCLUSIVE_ELEMENT_TAG = "maxInclusive";
    public static final String MAXLENGTH_ELEMENT_TAG = "maxLength";
    public static final String MINEXCLUSIVE_ELEMENT_TAG = "minExclusive";
    public static final String MININCLUSIVE_ELEMENT_TAG = "minInclusive";
    public static final String MINLENGTH_ELEMENT_TAG = "minLength";
    public static final String NOTATION_ELEMENT_TAG = "notation";
    public static final String PATTERN_ELEMENT_TAG = "pattern";
    public static final String REDEFINE_ELEMENT_TAG = "redefine";
    public static final String RESTRICTION_ELEMENT_TAG = "restriction";
    public static final String SCHEMA_ELEMENT_TAG = "schema";
    public static final String SELECTOR_ELEMENT_TAG = "selector";
    public static final String SEQUENCE_ELEMENT_TAG = "sequence";
    public static final String SIMPLECONTENT_ELEMENT_TAG = "simpleContent";
    public static final String SIMPLETYPE_ELEMENT_TAG = "simpleType";
    public static final String TOTALDIGITS_ELEMENT_TAG = "totalDigits";
    public static final String UNION_ELEMENT_TAG = "union";
    public static final String UNIQUE_ELEMENT_TAG = "unique";
    public static final String WHITESPACE_ELEMENT_TAG = "whiteSpace";
    public static final int ALL_ELEMENT = 0;
    public static final int ANNOTATION_ELEMENT = 1;
    public static final int ANY_ELEMENT = 2;
    public static final int ANYATTRIBUTE_ELEMENT = 3;
    public static final int APPINFO_ELEMENT = 4;
    public static final int ATTRIBUTE_ELEMENT = 5;
    public static final int ATTRIBUTEGROUP_ELEMENT = 6;
    public static final int CHOICE_ELEMENT = 7;
    public static final int COMPLEXCONTENT_ELEMENT = 8;
    public static final int COMPLEXTYPE_ELEMENT = 9;
    public static final int DOCUMENTATION_ELEMENT = 10;
    public static final int ELEMENT_ELEMENT = 11;
    public static final int ENUMERATION_ELEMENT = 12;
    public static final int EXTENSION_ELEMENT = 13;
    public static final int FIELD_ELEMENT = 14;
    public static final int FRACTIONDIGITS_ELEMENT = 15;
    public static final int GROUP_ELEMENT = 16;
    public static final int IMPORT_ELEMENT = 17;
    public static final int INCLUDE_ELEMENT = 18;
    public static final int KEY_ELEMENT = 19;
    public static final int KEYREF_ELEMENT = 20;
    public static final int LENGTH_ELEMENT = 21;
    public static final int LIST_ELEMENT = 22;
    public static final int MAXEXCLUSIVE_ELEMENT = 23;
    public static final int MAXINCLUSIVE_ELEMENT = 24;
    public static final int MAXLENGTH_ELEMENT = 25;
    public static final int MINEXCLUSIVE_ELEMENT = 26;
    public static final int MININCLUSIVE_ELEMENT = 27;
    public static final int MINLENGTH_ELEMENT = 28;
    public static final int NOTATION_ELEMENT = 29;
    public static final int PATTERN_ELEMENT = 30;
    public static final int REDEFINE_ELEMENT = 31;
    public static final int RESTRICTION_ELEMENT = 32;
    public static final int SCHEMA_ELEMENT = 33;
    public static final int SELECTOR_ELEMENT = 34;
    public static final int SEQUENCE_ELEMENT = 35;
    public static final int SIMPLECONTENT_ELEMENT = 36;
    public static final int SIMPLETYPE_ELEMENT = 37;
    public static final int TOTALDIGITS_ELEMENT = 38;
    public static final int UNION_ELEMENT = 39;
    public static final int UNIQUE_ELEMENT = 40;
    public static final int WHITESPACE_ELEMENT = 41;
    public static final String[] ELEMENT_TAGS = new String[]{"all", "annotation", "any", "anyAttribute", "appinfo", "attribute", "attributeGroup", "choice", "complexContent", "complexType", "documentation", "element", "enumeration", "extension", "field", "fractionDigits", "group", "import", "include", "key", "keyref", "length", "list", "maxExclusive", "maxInclusive", "maxLength", "minExclusive", "minInclusive", "minLength", "notation", "pattern", "redefine", "restriction", "schema", "selector", "sequence", "simpleContent", "simpleType", "totalDigits", "union", "unique", "whiteSpace"};
    public static final String ABSTRACT_ATTRIBUTE = "abstract";
    public static final String ATTRIBUTEFORMDEFAULT_ATTRIBUTE = "attributeFormDefault";
    public static final String BASE_ATTRIBUTE = "base";
    public static final String BLOCK_ATTRIBUTE = "block";
    public static final String BLOCKDEFAULT_ATTRIBUTE = "blockDefault";
    public static final String DEFREF_ATTRIBUTE = "defRef";
    public static final String DEFAULT_ATTRIBUTE = "default";
    public static final String ELEMENTFORMDEFAULT_ATTRIBUTE = "elementFormDefault";
    public static final String FINAL_ATTRIBUTE = "final";
    public static final String FINALDEFAULT_ATTRIBUTE = "finalDefault";
    public static final String FIXED_ATTRIBUTE = "fixed";
    public static final String FORM_ATTRIBUTE = "form";
    public static final String ID_ATTRIBUTE = "id";
    public static final String ITEMTYPE_ATTRIBUTE = "itemType";
    public static final String MAXOCCURS_ATTRIBUTE = "maxOccurs";
    public static final String MEMBERTYPES_ATTRIBUTE = "memberTypes";
    public static final String MINOCCURS_ATTRIBUTE = "minOccurs";
    public static final String MIXED_ATTRIBUTE = "mixed";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String NAMESPACE_ATTRIBUTE = "namespace";
    public static final String NILLABLE_ATTRIBUTE = "nillable";
    public static final String OCCURS_ATTRIBUTE = "occurs";
    public static final String PROCESSCONTENTS_ATTRIBUTE = "processContents";
    public static final String PUBLIC_ATTRIBUTE = "public";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String REFER_ATTRIBUTE = "refer";
    public static final String SCHEMALOCATION_ATTRIBUTE = "schemaLocation";
    public static final String SOURCE_ATTRIBUTE = "source";
    public static final String SUBSTITUTIONGROUP_ATTRIBUTE = "substitutionGroup";
    public static final String SYSTEM_ATTRIBUTE = "system";
    public static final String TARGETNAMESPACE_ATTRIBUTE = "targetNamespace";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String USE_ATTRIBUTE = "use";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VERSION_ATTRIBUTE = "version";
    public static final String XPATH_ATTRIBUTE = "xpath";
    public static final String SCHEMA_HAS_FACET_AND_PROPERTY_URI_2001 = "http://www.w3.org/2001/XMLSchema-hasFacetAndProperty";
    public static final String HFP_HASFACET_ELEMENT_TAG = "hasFacet";
    public static final String HFP_HASPROPERTY_ELEMENT_TAG = "hasProperty";
    public static final int HFP_HASFACET_ELEMENT = 0;
    public static final int HFP_HASPROPERTY_ELEMENT = 1;
    public static final String[] HFP_ELEMENT_TAGS = new String[]{"hasFacet", "hasProperty"};
    public static final String HFP_NAME_ATTRIBUTE = "name";
    public static final String HFP_VALUE_ATTRIBUTE = "value";

    public static boolean isXMLNamespace(String namespace) {
        return XML_NAMESPACE_URI_1998.equals(namespace);
    }

    public static boolean isXMLNSNamespace(String namespace) {
        return XMLNS_URI_2000.equals(namespace);
    }

    public static boolean isSchemaForSchemaNamespace(String namespace) {
        return SCHEMA_FOR_SCHEMA_URI_2001.equals(namespace) || SCHEMA_FOR_SCHEMA_URI_2000_10.equals(namespace) || SCHEMA_FOR_SCHEMA_URI_1999.equals(namespace);
    }

    public static boolean isSchemaInstanceNamespace(String namespace) {
        return SCHEMA_INSTANCE_URI_2001.equals(namespace);
    }

    public static final int nodeType(String localName) {
        int i = 0;
        while (i < ELEMENT_TAGS.length) {
            if (localName.equals(ELEMENT_TAGS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int nodeType(Node node) {
        return XSDConstants.isSchemaForSchemaNamespace(node.getNamespaceURI()) ? XSDConstants.nodeType(node.getLocalName()) : -1;
    }

    public static final String uri(Node node) {
        String namespaceURI = node.getNamespaceURI();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        return String.valueOf(namespaceURI) + "#" + node.getLocalName();
    }

    public static boolean isSchemaHasFacetAndPropertyNamespace(String namespace) {
        return SCHEMA_HAS_FACET_AND_PROPERTY_URI_2001.equals(namespace);
    }

    public static final int hfpNodeType(String localName) {
        int i = 0;
        while (i < HFP_ELEMENT_TAGS.length) {
            if (localName.equals(HFP_ELEMENT_TAGS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int hfpNodeType(Node node) {
        return XSDConstants.isSchemaHasFacetAndPropertyNamespace(node.getNamespaceURI()) ? XSDConstants.hfpNodeType(node.getLocalName()) : -1;
    }

    public static String lookupQNameForAttribute(Element element, String localNameOfAttribute) {
        if (element != null && element.hasAttribute(localNameOfAttribute)) {
            String qName = element.getAttribute(localNameOfAttribute);
            return XSDConstants.lookupQName(element, qName);
        }
        return "";
    }

    public static String lookupQName(Element element, String qName) {
        int index = qName == null ? -1 : qName.lastIndexOf(":");
        String namespaceAttribute = "xmlns";
        if (index != -1) {
            String prefix = qName.substring(0, index);
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace#" + qName.substring(index + 1);
            }
            namespaceAttribute = "xmlns:" + qName.substring(0, index);
        }
        Node node = element;
        while (node instanceof Element) {
            Element elementNode = node;
            if (elementNode.hasAttribute(namespaceAttribute)) {
                String namespace = elementNode.getAttribute(namespaceAttribute);
                String localName = qName == null ? "" : qName.substring(index + 1);
                return String.valueOf(namespace) + "#" + localName;
            }
            node = node.getParentNode();
        }
        return qName == null ? "" : (index == -1 ? qName : String.valueOf(qName.substring(0, index)) + "#" + qName.substring(index + 1));
    }

    /*
     * Unable to fully structure code
     */
    public static String lookupQualifier(Node node, String namespaceURI) {
        if (!"http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) ** GOTO lbl18
        return "xml";
lbl-1000:
        // 1 sources

        {
            elementNode = (Element)node;
            attributes = elementNode.getAttributes();
            i = 0;
            size = attributes.getLength();
            while (i < size) {
                attr = (Attr)attributes.item(i);
                name = attr.getNodeName();
                if (name.startsWith("xmlns") && ((candidateNamespaceURI = attr.getNodeValue()) == null || candidateNamespaceURI.length() == 0 ? namespaceURI == null || namespaceURI.length() == 0 : candidateNamespaceURI.equals(namespaceURI) != false)) {
                    index = name.indexOf(":");
                    if (index == -1) {
                        return "";
                    }
                    return name.substring(index + 1);
                }
                ++i;
            }
            node = node.getParentNode();
lbl18:
            // 2 sources

            ** while (node instanceof Element)
        }
lbl19:
        // 1 sources

        return namespaceURI == null || namespaceURI.length() == 0 ? "" : null;
    }

    public static String resolveSchemaLocation(String baseSchemaLocationURI, String namespaceURI, String schemaLocationURI) {
        try {
            if (schemaLocationURI == null) {
                schemaLocationURI = namespaceURI;
            }
            if (schemaLocationURI != null) {
                URI baseSchemaLocation = URI.createURI((String)baseSchemaLocationURI);
                URI schemaLocation = URI.createURI((String)schemaLocationURI);
                if (baseSchemaLocation.isHierarchical() && !baseSchemaLocation.isRelative() && schemaLocation.isRelative()) {
                    schemaLocation = schemaLocation.resolve(baseSchemaLocation);
                }
                return schemaLocation.toString();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return schemaLocationURI;
    }

    public static boolean isURType(XSDTypeDefinition xsdTypeDefinition) {
        String name = xsdTypeDefinition.getName();
        return XSDConstants.isSchemaForSchemaNamespace(xsdTypeDefinition.getTargetNamespace()) && ("anyType".equals(name) || "anySimpleType".equals(name));
    }

    public static boolean isAnyType(XSDTypeDefinition xsdTypeDefinition) {
        return XSDConstants.isSchemaForSchemaNamespace(xsdTypeDefinition.getTargetNamespace()) && "anyType".equals(xsdTypeDefinition.getName());
    }

    public static boolean isAnySimpleType(XSDTypeDefinition xsdTypeDefinition) {
        return XSDConstants.isSchemaForSchemaNamespace(xsdTypeDefinition.getTargetNamespace()) && "anySimpleType".equals(xsdTypeDefinition.getName());
    }

    public static boolean isOrIsDerivedFromID(XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        while (xsdSimpleTypeDefinition != null) {
            if (XSDConstants.isURType(xsdSimpleTypeDefinition)) {
                return false;
            }
            if (XSDConstants.isSchemaForSchemaNamespace(xsdSimpleTypeDefinition.getTargetNamespace()) && "ID".equals(xsdSimpleTypeDefinition.getName())) {
                return true;
            }
            xsdSimpleTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        }
        return false;
    }
}

