#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  Ref: phpMyAdmin team
#
#  This script is released under the GNU GPL v2

if(description)
{
 script_id(15478);
 script_bugtraq_id(11391);
 
 script_version("$Revision: 1.4 $");
 name["english"] = "phpMyAdmin remote command execution";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running phpMyAdmin, an open-source software
written in PHP to handle the administration of MySQL over the Web.

The remote version of this software is vulnerable to arbitrary
command execution due to a lack of user-supplied data
sanitization.

Solution : Upgrade to version 2.6.0-pl2 or newer
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of phpMyAdmin";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if (!can_host_php(port:port) ) exit(0);

foreach dir (cgi_dirs()) 
{
  req = http_get(item:dir + "/main.php", port:port);
  res = http_keepalive_send_recv(port:port, data:req);
  if ( res == NULL ) exit(0);
  str = egrep(pattern:"Welcome to *phpMyAdmin", string:res);
  if ( str )
  {
    version = ereg_replace(pattern:".*Welcome *to *phpMyAdmin (.*)</h1>.*", string:str, replace:"\1");
    if ( dir == "" ) dir = "/";
    set_kb_item(name:"www/" + port + "/phpMyAdmin", 
		value:version + " under " + dir );

    if ( ereg(pattern:"(2\.[0-5]\..*|2\.6\.0$|2\.6\.0-pl1)", string:version) ) security_hole(port);
    exit(0);
  }
}
