#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12595);
 script_bugtraq_id(9564);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0129");
 name["english"] = "FreeBSD Ports : phpMyAdmin <= 2.5.4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of phpMyAdmin installed.

phpMyAdmin is a set of PHP-scripts to administer a MySQL database over the web.
There is a bug in the remote version of this software which may allow an
attacker to read the content of any file on the target system that is readable
by the web server.

Solution : http://www.vuxml.org/freebsd/cc0fb686-6550-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpMyAdmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^phpMyAdmin-", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"phpMyAdmin-2.5.4_1") < 0 ) 
	security_hole(0);
