#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12563);
 script_bugtraq_id(10244);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0421");
 name["english"] = "FreeBSD Ports : libpng < 1.2.5_4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the libpng package which is older
than 1.2.5_4.

libpng is a package which contains a library of functions which 
support program designed to manipulate the PNG file format.

There is a bug in the remote version of libpng which may allow an
attacker to make libpng-enabled program to crash when reading
a specially malformed .png file.

Solution : http://www.vuxml.org/freebsd/3a408f6f-9c52-11d8-9366-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^libpng-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"libpng-1.2.5_4") < 0 ) 
	security_hole(0);
