#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15801);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11523 );
 script_cve_id ( "CAN-2004-0990" );
 name["english"] = "FreeBSD Ports : gd < 2.0.29,1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

gd < 2.0.29,1
ja-gd < 2.0.29,1
uk-gd < 2.0.29,1

There is an integer overflow when allocating memory in  the routine that 
handles loading PNG image files. This later leads to heap data structures 
being overwritten. If  an attacker tricked a user into loading a malicious PNG 
image, they could leverage this into executing arbitrary  code in the context 
of the user opening image.

See also : http://marc.theaimsgroup.com/?l=bugtraq&m=109882489302099
Solution : http://www.vuxml.org/freebsd/62239968-2f2a-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^gd-[0-2]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"gd-2.0.29,1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^ja-gd-[0-2]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ja-gd-2.0.29,1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^uk-gd-[0-2]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"uk-gd-2.0.29,1") < 0  )
	{
	security_hole(0);
	exit(0);
	}
