\name{QC}
\alias{QC}
\alias{checkDocFiles}
\alias{checkDocStyle}
\alias{checkReplaceFuns}
\alias{checkS3methods}
\alias{print.checkDocFiles}
\alias{print.checkDocStyle}
\alias{print.checkReplaceFuns}
\alias{print.checkS3methods}
\title{QC Checks for R Code and/or Documentation}
\description{
  Functions for performing various quality checks.
}
\usage{
checkDocFiles(package, dir, lib.loc = NULL)
checkDocStyle(package, dir, lib.loc = NULL)
checkReplaceFuns(package, dir, lib.loc = NULL)
checkS3methods(package, dir, lib.loc = NULL)
}
\arguments{
  \item{package}{a character string naming an installed package.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This should contain the subdirectories \code{R}
    (for R code) and \file{man} with \R documentation sources (in Rd
    format).  Only used if \code{package} is not given.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
}
\details{
  \code{checkDocFiles} checks, for all Rd files in a package, whether all
  arguments shown in the usage sections of the Rd file are documented in
  its arguments section.  It also reports duplicated entries in the
  arguments section, and \dQuote{over-documented} arguments which are
  given in the arguments section but not in the usage.  Note that the
  match is for the usage section and not a possibly existing synopsis
  section, as the usage is what gets displayed.

  \code{checkDocStyle} investigates how (S3) methods are shown in the
  usages of the Rd files in a package.  It reports the methods shown by
  their full name rather than using the Rd \code{\\method} markup for
  indicating S3 methods.  Earlier versions of \R also reported about
  methods shown along with their generic, which typically caused
  problems for the documentation of the primary argument in the generic
  and its methods.  With \code{\\method} now being expanded in a way
  that class information is preserved, \dQuote{joint} documentation is
  no longer necessarily a problem.  (The corresponding information is
  still contained in the object returned by \code{checkDocStyle}.)

  \code{checkReplaceFuns} checks whether replacement functions or S3/S4
  replacement methods in the package R code have their final argument
  named \code{value}.

  \code{checkS3methods} checks whether all S3 methods defined in the
  package R code have all arguments of the corresponding generic, with
  positional arguments of the generics in the same positions for the
  method.  As an exception, the first argument of a formula method
  \emph{may} be called \code{formula} even if this is not the name used
  by the generic.  The rules when \code{\dots} is involved are subtle:
  see the source code.  Functions recognized as S3 generics are those
  with a call to \code{UseMethod} in their body, internal S3 generics
  (see \code{\link[base]{InternalMethods}}), and S3 group generics (see
  \code{\link[base]{Math}}).  Possible dispatch under a different name
  is not taken into account.  The generics are sought first in the given
  package, then in the \pkg{base} package and (currently) the packages 
  \pkg{graphics}, \pkg{stats}, and \pkg{utils} added in R 1.9.0 by
  splitting the former \pkg{base}, and, if an installed package is
  tested, also in the loaded namespaces/packages listed in the package's
  \file{DESCRIPTION} Depends field.

  If using an installed package, the checks needing access to all R
  objects of the package will load the package (unless it is the
  \pkg{base} package), after possibly detaching an already loaded
  version of the package.
}
\value{
  The functions return objects of class the same as the respective
  function names containing the information about problems detected.
  There is a \code{print} method for nicely displaying the information
  contained in such objects.
}
\section{Warning}{
  These functions are still experimental.  Names, interfaces and values
  might change in future versions.
}
\keyword{utilities}
\keyword{documentation}
\eof
\name{Rdindex}
\title{Generate Index from Rd Files}
\alias{Rdindex}
\description{
  Print a 2-column index table with \dQuote{names} and titles from given
  R documentation files to a given output file or connection.  The
  titles are nicely formatted between two column positions (typically 25
  and 72, respectively).
}
\usage{
Rdindex(RdFiles, outFile = "", type = NULL,
        width = 0.9 * getOption("width"), indent = NULL)
}
\arguments{
  \item{RdFiles}{a character vector specifying the Rd files to be used
    for creating the index, either by giving the paths to the files, or
    the path to a single directory with the sources of a package.}
  \item{outFile}{a connection, or a character string naming the output
    file to print to.  \code{""} (the default) indicates output is to
    the console.}
  \item{type}{a character string giving the documentation type of the Rd
    files to be included in the index, or \code{NULL} (the default).
    The type of an Rd file is typically specified via the
    \code{\\docType} tag; if \code{type} is \code{"data"}, Rd files
    whose \emph{only} keyword is \code{datasets} are included as well.}
  \item{width}{a positive integer giving the target column for wrapping
    lines in the output.}
  \item{indent}{a positive integer specifying the indentation of the
    second column.  Must not be greater than \code{width/2}, and
    defaults to \code{width/3}.}
}
\details{
  If a name is not a valid alias, the first alias (or the empty string
  if there is none) is used instead.
}
%% Currently no \example: at run time we do not have direct access to Rd
%% files.  What we could do is take an installed Rd archive, and extract
%% by splitting on the new-style \eof file separator, but we really want
%% a simple example, right?
\keyword{documentation}
\keyword{utilities}
\eof
\name{buildVignettes}
\alias{buildVignettes}
\alias{pkgVignettes}
\title{List and Build Package Vignettes}
\description{
  Run \code{\link[utils]{Sweave}} and \code{\link{texi2dvi}} on all vignettes
  of a package.
}
\usage{
buildVignettes(package, dir, lib.loc = NULL, quiet=TRUE)
pkgVignettes(package, dir, lib.loc = NULL)
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, Sweave files are searched in subdirectory \code{doc}.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This subdirectory \code{inst/doc} is searched for
    Sweave files.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
  \item{quiet}{logical. Run \code{\link[utils]{Sweave}} and
    \code{\link{texi2dvi}} in quiet mode.}
}
\value{
  \code{buildVignettes} is called for its side effect of creating the
  PDF versions of all vignettes.
  
  \code{pkgVignettes} returns an object of class \code{"pkgVignettes"}.
}
\keyword{utilities}
\keyword{documentation}
\eof
\name{checkFF}
\alias{checkFF}
\alias{print.checkFF}
\title{Check Foreign Function Calls}
\usage{
checkFF(package, dir, file, lib.loc = NULL,
        verbose = getOption("verbose"))
}
\description{
  Performs checks on calls to compiled code from R code.  Currently only
  whether the interface functions such as \code{.C} and \code{.Fortran}
  are called with argument \code{PACKAGE} specified, which is highly
  recommended to avoid name clashes in foreign function calls.
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, the installed R code of the package is checked.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This should contain the subdirectory \code{R}
    (for R code).  Only used if \code{package} is not given.}
  \item{file}{the name of a file containing R code to be checked.  Used
    if neither \code{package} nor \code{dir} are given.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
  \item{verbose}{a logical.  If \code{TRUE}, additional diagnostics are
    printed (and the result is returned invisibly).}
}
\value{
  An object of class \code{"checkFF"}, which currently is a list of the
  (parsed) foreign function calls with no \code{PACKAGE} argument.

  There is a \code{print} method for nicely displaying the information
  contained in such objects.
}
\seealso{
  \code{\link{.C}},
  \code{\link{.Fortran}};
  \code{\link{Foreign}}.
}
\section{Warning}{
  This function is still experimental.  Both name and interface might
  change in future versions.
}
\examples{
checkFF(package = "stats", verbose = TRUE)
}
\keyword{programming}
\keyword{utilities}
\eof
\name{checkMD5sums}
\alias{checkMD5sums}
\alias{.installMD5sums}
\title{Check and Create MD5 Checksum Files}
\description{
  \code{checkMD5sums} checks the files against a file \code{MD5};
  \code{.installMD5sums} creates such a file.
}
\usage{
checkMD5sums(pkg, dir)
.installMD5sums(pkgDir, outDir = pkgDir)
}
\arguments{
  \item{pkg}{the name of an installed package}
  \item{dir, pkgDir}{the path to the top-level directory of an installed
    package.}
  \item{outDir}{the directory within which to create the \code{MD5} file.}
}
\details{
  The file \file{MD5} which is created is in a format which can be
  checked by \code{md5sum -c MD5} if a suitable command-line version of
  \code{md5sum} is available.

  If \code{dir} is missing, an installed package of name \code{pkg} is
  searched for.
}
\value{
  \code{checkMD5sums} returns a logical, \code{NA} if there is no
  \code{MD5} file to be checked.
}
\seealso{\code{\link{md5sum}}}

\keyword{utilities}
\eof
\name{checkTnF}
\alias{checkTnF}
\alias{print.checkTnF}
\title{Check R Packages or Code for T/F}
\description{
  Checks the specified R package or code file for occurrences of
  \code{T} or \code{F}, and gathers the expression containing these.
  This is useful as in R \code{T} and \code{F} are just variables which
  are set to the logicals \code{TRUE} and \code{FALSE} by default, but
  are not reserved words and hence can be overwritten by the user.
  Hence, one should always use \code{TRUE} and \code{FALSE} for the
  logicals.
}
\usage{
checkTnF(package, dir, file, lib.loc = NULL)
}
\arguments{
  \item{package}{a character string naming an installed package.  If
    given, the installed R code and the examples in the documentation
    files of the package are checked.  R code installed as an image file
    cannot be checked.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This must contain the subdirectory \file{R} (for
    R code), and should also contain \file{man} (for documentation).
    Only used if \code{package} is not given.  If used, the R code files
    and the examples in the documentation files are checked.}
  \item{file}{the name of a file containing R code to be checked.  Used
    if neither \code{package} nor \code{dir} are given.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
}
\value{
  An object of class \code{"checkTnF"} which is a list containing, for
  each file where occurences of \code{T} or \code{F} were found, a list
  with the expressions containing these occurrences.  The names of the
  list are the corresponding file names.

  There is a \code{print} method for nicely displaying the information
  contained in such objects.
}
\section{Warning}{
  This function is still experimental.  Both name and interface might
  change in future versions.
}
\keyword{utilities}
\keyword{documentation}
\eof
\name{checkVignettes}
\alias{checkVignettes}
\alias{print.checkVignettes}
\title{Check Package Vignettes}
\description{
  Check all \code{\link[utils]{Sweave}} files of a package by running
  \code{\link[utils]{Sweave}} and/or \code{\link[utils]{Stangle}} on them. All
  R source code files found after the tangling step are
  \code{\link{source}}ed to check whether all code can be
  executed without errors.
}
\usage{
checkVignettes(package, dir, lib.loc = NULL, tangle = TRUE,
               weave = TRUE, workdir = c("tmp", "src", "cur"),
               keepfiles = FALSE)
}
\arguments{
 \item{package}{a character string naming an installed package.  If
    given, Sweave files are searched in subdirectory \code{doc}.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This subdirectory \code{inst/doc} is searched for
    Sweave files.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
  \item{tangle}{Perform a tangle and \code{\link{source}} the extraced code?}
  \item{weave}{Perform a weave?}
  \item{workdir}{Directory used as working directory while checking the
    vignettes. If \code{"tmp"} then a temporary directory is created,
    this is the default.  If \code{"src"} then the directory containing
    the vignettes itself is used, if \code{"cur"} then the current
    working directory of \R is used.}
  \item{keepfiles}{Delete file in temporary directory? This option is
    ignored when \code{workdir!="tmp"}.}
}
\value{
  An object of class \code{"checkVignettes"} which is a list with the
  error messages found during the tangle and weave steps. There is a
  \code{print} method for nicely displaying the information 
  contained in such objects.
}
\keyword{utilities}
\keyword{documentation}
\eof
\name{codoc}
\alias{codoc}
\alias{codocClasses}
\alias{codocData}
\alias{print.codoc}
\alias{print.codocClasses}
\alias{print.codocData}
\title{Check Code/Documentation Consistency}
\usage{
codoc(package, dir, lib.loc = NULL,
      use.values = NULL, verbose = getOption("verbose"))
codocClasses(package, lib.loc = NULL)
codocData(package, lib.loc = NULL)
}
\description{
  Find inconsistencies between actual and documented \dQuote{structure}
  of \R objects in a package.  \code{codoc} compares names and
  optionally also corresponding positions and default values of the
  arguments of functions.  \code{codocClasses} and \code{codocData}
  compare slot names of S4 classes and variable names of data sets,
  respectively.
}
\arguments{
  \item{package}{a character string naming an installed package.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This must contain the subdirectories \file{man}
    with \R documentation sources (in Rd format) and \file{R} with \R
    code.  Only used if \code{package} is not given.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
  \item{use.values}{if \code{FALSE}, do not use function default values
    when comparing code and docs.  Otherwise, compare \emph{all} default
    values if \code{TRUE}, and only the ones documented in the usage
    otherwise (default).}
  \item{verbose}{a logical.  If \code{TRUE}, additional diagnostics are
    printed.}
}
\note{
  The default for \code{use.values} has been changed from
  \code{FALSE} to \code{NULL}, for \R versions 1.9.0 and later.
}
\details{
  The purpose of \code{codoc} is to check whether the documented usage
  of function objects agrees with their formal arguments as defined in
  the \R code.  This is not always straightforward, in particular as the
  usage information for methods to generic functions often employs the
  name of the generic rather than the method.

  The following algorithm is used.  If an installed package is used, it
  is loaded (unless it is the base package), after possibly detaching an
  already loaded version of the package.  Otherwise, if the sources are
  used, the \R code files of the package are collected and sourced in a
  new environment.  Then, the usage sections of the Rd files are
  extracted and parsed \dQuote{as much as possible} to give the formals
  documented.  For interpreted functions in the code environment, the
  formals are compared between code and documentation according to the
  values of the argument \code{use.values}.  Synopsis sections are used
  if present; their occurrence is reported if \code{verbose} is true.

  Currently, the R documentation format has no high-level markup for the
  basic \dQuote{structure} of classes and data sets (similar to the usage
  sections for function synopses).  Variable names for data frames in
  documentation objects obtained by suitably editing \dQuote{shells}
  created by \code{\link[code]{prompt}} are recognized by \code{codocData}
  and used provided that the documentation object is for a single data
  frame (i.e., only has one alias).  \code{codocClasses} analogously
  handles slot names for classes in documentation objects obtained by
  editing shells created by \code{\link[methods]{promptClass}}.
}
\value{
  \code{codoc} returns an object of class \code{"codoc"}.  Currently,
  this is a list which, for each Rd object in the package where an
  inconsistency was found, contains an element with a list of the
  mismatches (which in turn are lists with elements \code{code} and
  \code{docs}, giving the corresponding arguments obtained from the
  function's code and documented usage).

  \code{codocClasses} and \code{codocData} return objects of class
  \code{"codocClasses"} and \code{"codocData"}, respectively, with a
  structure similar to class \code{"codoc"}.

  There are \code{print} methods for nicely displaying the information
  contained in such objects.
}
\seealso{
  \code{\link{undoc}}
}
\section{Warning}{
  Both \code{codocClasses} and \code{codocData} are still experimental.
  Names, interfaces and values might change in future versions.
}
\keyword{documentation}
\eof
\name{delimMatch}
\alias{delimMatch}
\title{Delimited Pattern Matching}
\description{
  Match delimited substrings in a character vector, with proper nesting.
}
\usage{
delimMatch(x, delim = c("\{", "\}"), syntax = "Rd")
}
\arguments{
  \item{x}{a character vector.}
  \item{delim}{a character vector of length 2 giving the start and end
    delimiters.  Currently, both must be single characters.  Future
    versions might allow for arbitrary regular expressions.}
  \item{syntax}{currently, always the string \samp{"Rd"} indicating Rd
    syntax (i.e., \samp{\%} starts a comment extending till the end of
    the line, and \samp{\\} escapes).  Future versions might know about
    other syntaxes, perhaps via \dQuote{syntax tables} allowing to
    flexibly specify comment, escape, and quote characters.}
}
\value{
  An integer vector of the same length as \code{x} giving the starting
  position of the first match, or \eqn{-1} if there is none, with
  attribute \code{"match.length"} giving the length of the matched text
  (or \eqn{-1} for no match).
}
\seealso{
  \code{\link{regexpr}} for \dQuote{simple} pattern matching.
}
\examples{
x <- c("\value\{foo\}", "function(bar)")
delimMatch(x)
delimMatch(x, c("(", ")"))
}
\keyword{character}
\eof
\name{fileutils}
\alias{filePathAsAbsolute}
\alias{filePathSansExt}
\alias{fileTest}
\alias{listFilesWithExts}
\alias{listFilesWithType}
\title{File Utilities}
\description{
  Utilities for testing and listing files, and manipulating file paths.
}
\usage{
filePathAsAbsolute(x)
filePathSansExt(x)
fileTest(op, x, y)
listFilesWithExts(dir, exts, all.files = FALSE, full.names = TRUE)
listFilesWithType(dir, type, all.files = FALSE, full.names = TRUE)
}
\arguments{
  \item{x,y}{character vectors giving file paths.}
  \item{op}{a character string specifying the test to be performed.
    Unary tests (only \code{x} is used) are \code{"-f"} (existence and
    not being a directory) and \code{"-d"} (existence and directory);
    binary tests are \code{"-nt"} (newer than, using the modification
    dates) and \code{"-ot"}.}
  \item{dir}{a character string with the path name to a directory.}
  \item{exts}{a character vector of possible file extensions.}
  \item{all.files}{a logical.  If \code{FALSE} (default), only visible
    files are considered; if \code{TRUE}, all files are used.}
  \item{full.names}{a logical indicating whether the full paths of the
    files found are returned (default), or just the file names.}
  \item{type}{a character string giving the \dQuote{type} of the files
    to be listed, as characterized by their extensions.  Currently,
    possible values are \code{"code"} (R code), \code{"data"} (data
    sets), \code{"demo"} (demos), \code{"docs"} (R documentation), and
    \code{"vignette"} (vignettes).}
}
\details{
  \code{filePathAsAbsolute} turns a possibly relative file path
  absolute, performing tilde expansion if necessary.  Currently, only a
  single existing path can be given.

  \code{filePathSansExt} returns the file paths without extensions.
  (Only purely alphanumeric extensions are recognized.)

  \code{fileTest} performs shell-style file tests.  Note that
  \code{\link{file.exists}} only tests for existence (\code{test -e} on
  some systems) but not for not being a directory.

  \code{listFilesWithExts} returns the paths or names of the files in
  directory \code{dir} with extension matching one of the elements of
  \code{exts}.  Note that by default, full paths are returned, and that
  only visible files are used.

  \code{listFilesWithType} returns the paths of the files in \code{dir}
  of the given \dQuote{type}, as determined by the extensions recognized
  by \R.  When listing R code and documentation files, files in
  OS-specific subdirectories are included if present.  Note that by
  default, full paths are returned, and that only visible files are
  used.
}
\seealso{
  \code{\link{file.path}},
  \code{\link{file.info}},
  \code{\link{list.files}}
}
\examples{
dir <- file.path(R.home(), "library", "stats")
fileTest("-d", dir)
fileTest("-nt", file.path(dir, "R"), file.path(dir, "demo"))
listFilesWithExts(file.path(dir, "demo"), "R")
listFilesWithType(file.path(dir, "demo"), "demo") # the same
filePathSansExt(list.files(file.path(R.home(), "modules")))
}
\keyword{file}
\eof
\name{getDepList}
\alias{getDepList}
\alias{pkgDepends}
\title{Functions to retrieve dependency information}
\description{
  Given a dependency matrix, will create a \code{DependsList} object for that
  package which will include the dependencies for that matrix, which
  ones are installed, which unresolved dependencies were found online,
  which unresolved dependencies were not found online, and any R dependencies.
}
\usage{
getDepList(depMtrx, instPkgs, recursive=TRUE, local=TRUE, reduce=TRUE,
           lib.loc=NULL)
pkgDepends(pkg, recursive = TRUE, local = TRUE, reduce = TRUE, lib.loc=NULL)
}
\arguments{
  \item{depMtrx}{A dependency matrix as from \code{package.dependencies}}
  \item{pkg}{The name of the package}
  \item{instPkgs}{A matrix specifying all packages installed on the
    local system, as from \code{installed.packages}}
  \item{recursive}{Whether or not to include indirect dependencies}
  \item{local}{Whether or not to search only locally}
  \item{reduce}{Whether or not to collapse all sets of dependencies to a
    minimal value}
  \item{lib.loc}{What libraries to use when looking for installed
    packages.  \code{NULL} indicates all library directories in the
    user's \code{.libPaths()}.}
}
\details{
  The function \code{pkgDepends} is a convenience function which wraps
  \code{getDepList} and takes as input a package name.  It will then
  query \code{\link[utils:update.packages]{installed.packages}}
  and also generate a dependency
  matrix, calling \code{getDepList} with this information and returning
  the result.
  
  These functions will retrieve information about the dependencies of
  the matrix, resulting in a \code{DependsList} object.  This is a
  list with four elements:
  \describe{
    \item{Depends}{A vector of the dependencies for this package.}
    \item{Installed}{A vector of the dependencies which have been
      satisfied by the currently installed packages.}
    \item{Found}{A list representing the dependencies which are not in
      \code{Installed} but were found online.  This list has element
      names which are the URLs for the repositories in which packages
      were found and the elements themselves are vectors of package
      names which were found in the respective repositories.  If
      \code{local=TRUE}, the \code{Found} element will always be empty.}
    \item{R}{Any R version dependencies.}
  }
    
  If \code{recursive} is \code{TRUE}, any package that is specified as a
  dependency will in turn have its dependencies included (and so on),
  these are known as indirect dependencies.  If \code{recursive} is 
  \code{FALSE}, only the dependencies directly stated by the package will 
  be used.

  If \code{local} is \code{TRUE}, the system will only look at the user's local
  install and not online to find unresolved dependencies.

  If \code{reduce} is \code{TRUE}, the system will collapse the fields in the
  \code{DependsList} object such that a minimal set of dependencies
  are specified (for instance if there was ('foo', 'foo (>= 1.0.0)',
  'foo (>= 1.3.0)'), it would only return 'foo (>= 1.3.0)').
}
\value{
  An object of class \code{DependsList}
}
\author{ Jeff Gentry }
\seealso{\code{\link{installFoundDepends}}}
\examples{
pkgDepends("tools", local = FALSE)
}
\keyword{utilities}

\eof
\name{installFoundDepends}
\alias{installFoundDepends}
\title{A function to install unresolved dependencies}
\description{
  This function will take the \code{Found} element of a
  \code{pkgDependsList} object and attempt to install 
  all of the listed packages from the specified repositories.
}
\usage{
installFoundDepends(depPkgList, ...)
}
\arguments{
  \item{depPkgList}{A \code{Found} element from a \code{pkgDependsList} object}
  \item{\dots}{Arguments to pass on to \code{\link[utils]{install.packages}}}
}
\details{
  This function takes as input the \code{Found} list from a
  \code{pkgDependsList} object.  This list will have element names being
  URLs corresponding to repositories and the elements will be vectors of
  package names.  For each element, \code{\link[utils]{install.packages}} is
  called for that URL to install all packages listed in the vector.
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgDepends}}, \code{\link[utils]{install.packages}}}
\examples{
## Set up a temporary directory to install packages to
tmp <- tempfile()
dir.create(tmp)

pDL <- pkgDepends("tools",local=FALSE)
installFoundDepends(pDL$Found, destdir=tmp)
}
\keyword{utilities}
\eof
\name{md5sum}
\alias{md5sum}
\title{Compute MD5 Checksums}
\description{
  Compute the 32-byte MD5 checksums of one or more files.
}
\usage{
md5sum(files)
}
\arguments{
  \item{files}{character. The paths of file(s) to be check-summed.}
}
\value{
  A character vector of the same length as \code{files}, with names
  equal to \code{files}. The elements
  will be \code{NA} for non-existent or unreadable files, otherwise
  a 32-character string of hexadecimal digits.

  On Windows all files are read in binary mode (as the \code{md5sum}
  utilities there do): on other OSes the files are read in the default way.
}
\seealso{
  \code{\link{checkMD5sums}}
}
\examples{
md5sum(dir(R.home(), pattern="^COPY", full.names=TRUE))
}
\keyword{utilities}

\eof
\name{texi2dvi}
\alias{texi2dvi}
\title{Compile LaTeX Files}
\description{Run latex and bibtex until all cross-references are
  resolved and create either a dvi or PDF file.}
\usage{
texi2dvi(file, pdf = FALSE, clean = FALSE, quiet = TRUE,
         texi2dvi = getOption("texi2dvi"))
}
\arguments{
  \item{file}{character.  Name of TeX source file.}
  \item{pdf}{logical.  If \code{TRUE}, a PDF file is produced insted of
    the default dvi file (texi2dvi command line option \option{--pdf}).}
  \item{clean}{logical.  If \code{TRUE}, all auxiliary files are removed
    (texi2dvi command line option \option{--clean}). Does not work on
    some platforms.}
  \item{quiet}{logical.  No output unless an error occurs.}
  \item{texi2dvi}{character (or \code{NULL}).  Script or program used to
    compile a TeX file to dvi or PDF, respectively.  If set to
    \code{NULL}, the \file{texi2dvi} script in R's \file{bin} directory
    is used (if it exists), otherwise it is assumed that
    \command{texi2dvi} is in the search path.}
}
\details{
  Some TeX installations on Windows do not have \file{texi2dvi.exe}.  If
  \file{texify.exe} is present (e.g., part of MikTeX), then it can be 
  used instead: set \code{options(texi2dvi="texify.exe")} or to the full
  path of the program.
}
\author{Achim Zeileis}
\keyword{utilities}
\eof
\name{tools-internal}
\title{Internal tools Objects}
% \alias{.isS3Generic}
% \alias{.loadPackageQuietly}
% \alias{.makeFileExts}
% \alias{.makeS3MethodsStopList}
% \alias{.sourceAssignments}
% \alias{Rdcontents}
% \alias{Rd2contents}
\alias{.installPackageCodeFiles}
\alias{.installPackageDescription}
\alias{.installPackageIndices}
% \alias{.installPackageRdIndices}
% \alias{.installPackageVignetteIndex}
% \alias{.installPackageDemoIndex}
% \alias{.writeContentsRDS}
% \alias{.writeContentsDCF}
% \alias{.buildRdIndex}
% \alias{.buildVignetteIndex}
% \alias{.buildDemoIndex}
% \alias{.buildDataIndex}
\alias{.installPackageNamespaceInfo}
\alias{.checkVignetteIndex}
\alias{print.checkVignetteIndex}
\alias{.checkDemoIndex}
\alias{print.checkDemoIndex}
% \alias{.stripRdComments}
\description{
  Internal tools functions.
}
\usage{
% .isS3Generic(fname, envir)
% .loadPackageQuietly(package, lib.loc)
% .makeFileExts(type)
% .makeS3MethodsStopList(package)
% .sourceAssignments(file, envir)
% Rdpp(lines)
% Rdinfo(file)
% Rdcontents(RdFiles)
% Rd2contents(dir, outFile = "")
% .stripRdComments(lines)
% .writeContentsRDS(contents, outFile)
% .writeContentsDCF(contents, packageName, outFile)
% .buildDataIndex(dataDir, contents)
% .buildDemoIndex(demoDir)
% .buildRdIndex(contents, type = NULL)
% .buildVignetteIndex(vignetteDir)
.installPackageCodeFiles(dir, outDir)
.installPackageDescription(dir, outDir)
.installPackageIndices(dir, outDir)
% .installPackageRdIndices(dir, outDir)
% .installPackageVignetteIndex(dir, outDir)
% .installPackageDemoIndex(dir, outDir)
.installPackageNamespaceInfo(dir, outDir)
.checkDemoIndex(demoDir)
.checkVignetteIndex(vignetteDir)
}
\details{
  These are not to be called by the user.
}
\keyword{internal}
\eof
\name{undoc}
\alias{undoc}
\alias{print.undoc}
\title{Find Undocumented Objects}
\usage{
undoc(package, dir, lib.loc = NULL)
}
\description{
  Finds the objects in a package which are undocumented, in the sense
  that they are visible to the user (or data objects or S4 classes
  provided by the package), but no documentation entry exists.
}
\arguments{
  \item{package}{a character string naming an installed package.}
  \item{dir}{a character string specifying the path to a package's root
    source directory.  This must contain the subdirectory \file{man}
    with \R documentation sources (in Rd format), and at least one of
    the \file{R} or \file{data} subdirectories with \R code or data
    objects, respectively.}
  \item{lib.loc}{a character vector of directory names of \R libraries,
    or \code{NULL}.  The default value of \code{NULL} corresponds to all
    libraries currently known.  The specified library trees are used to
    to search for \code{package}.}
}
\details{
  This function is useful for package maintainers mostly.  In principle,
  \emph{all} user level \R objects should be documented; note however
  that the precise rules for documenting methods of generic functions
  are still under discussion.
}
\value{
  An object of class \code{"undoc"} which is a list of character vectors
  containing the names of the undocumented objects split according to
  documentation type.  This representation is still experimental, and
  might change in future versions.

  There is a \code{print} method for nicely displaying the information
  contained in such objects.
}
\examples{
undoc("tools")                  # Undocumented objects in 'tools'
}
\keyword{documentation}
\eof
\name{vignetteDepends}
\alias{vignetteDepends}
\title{A function to retrieve dependency information for a vignette}
\description{
  Given a vignette name, will create a DependsList object that reports
  information about the packages the vignette depends on.
}
\usage{
vignetteDepends(vignette, recursive = TRUE, reduce = TRUE, local=TRUE, lib.loc=NULL)
}
\arguments{
  \item{vignette}{The name of the vignette}
  \item{recursive}{Whether or not to include indirect dependencies}
  \item{reduce}{Whether or not to collapse all sets of dependencies to a
    minimal value}
  \item{local}{Whether or not to search only locally}
  \item{lib.loc}{What libraries to search in locally}
}
\details{
  If \code{recursive} is \code{TRUE}, any package that is specified as a
  dependency will in turn have its dependencies included (and so on),
  these are known as indirect dependencies.  If recursive is
  \code{FALSE}, only the dependencies directly named by the vignette
  will be used.

  If \code{local} is \code{TRUE}, the system will only look at the
  user's local machine and not online to find dependencies.

  If \code{reduce} is \code{TRUE}, the system will collapse the fields
  in the \code{DependsList} to the minimal set of dependencies (for
  instance if the dependencies were ('foo', 'foo (>= 1.0.0)', 
  'foo (>= 1.3.0)'), the return value would be 'foo (>= 1.3.0)').
}
\value{
  An object of class \code{DependsList}
}
\author{ Jeff Gentry }
\seealso{\code{\link{pkgDepends}}}
\examples{
   ## We aren't guaranteed any vignettes in the base set of
   ## packages (yet) that I know of.
}
\keyword{utilities}
\eof
