#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12541);
 script_bugtraq_id(8843);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0792");
 name["english"] = "FreeBSD Ports : fetchmail < 6.2.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the fetchmail package which is
older than 6.2.5.

Fetchmail is a batch mail retrieval utility for several protocols (POP, IMAP and
many more). There is a bug in the remote version of fetchmail which may allow
an attacker to crash it by sending a message with a very long line to a 
fetchmail user of the remote host.

An attacker could exploit this vulnerability to prevent fetchmail users
of the remote host from getting email.

Solution : http://www.vuxml.org/freebsd/ac4b9d18-67a9-11d8-80e3-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fetchmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^fetchmail", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"fetchmail-6.2.5") < 0 ) 
	security_warning(0);
