#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12529);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0519");


 name["english"] = "FreeBSD Ports : Content-Type XSS vulnerabilities in webmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of at least one of the following packages :

  openwebmail <= 2.32
  ilohamail < 0.8.13


Both are webmail interfaces. There is a vulnerability in both packages which
may allow an attacker to perform a cross site scripting attack against a
user of the webmail interface.

To exploit this flaw, an attacker would need to send an email to a victim
using this webmail interface with a specially crafted Content-Type mime
content in his message, containing a rogue javascript. By sending an appropriate
script, the attacker could then obtain the user's cookie and read his email
through the remote web interface.

Solution : http://www.vuxml.org/freebsd/c5519420-cec2-11d8-8898-000d6111a684.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of various packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^openwebmail-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"openwebmail-2.32") <= 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^ilohamail-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ilohamail-0.8.13") < 0 ) 
	security_hole(0);
