#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15497);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id(11385);
 script_cve_id("CAN-2004-0918");
 name["english"] = "FreeBSD Ports: squid < 2.5.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of squid installed.

Squid is a Web proxy cache. There is a bug in the remote version of this
software which may allow an attacker to cause a denial of service attack
against the remote service by sending a malformed SNMP query to the proxy.

Solution : http://www.vuxml.org/freebsd/65e99f52-1c5f-11d9-bc4a-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the squid package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^squid-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"squid-2.5.7") < 0 ) 
	security_warning(0);
