#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15812);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id( 11505 );
 name["english"] = "FreeBSD Ports : socat < 1.4.0.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

socat < 1.4.0.3

socat up to version 1.4.0.2 contains a syslog() based  format string 
vulnerability. 
This vulnerability could  under some circumstances lead to local or remote 
execution of arbitrary code with the privileges of the socat process.

Solution : http://www.vuxml.org/freebsd/f3017ce1-32a4-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the socat package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^socat-[01]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"socat-1.4.0.3") < 0  )
	{
	security_hole(0);
	exit(0);
	}
