#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12588);
 script_bugtraq_id(9899);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0079");
 name["english"] = "FreeBSD : OpenSSL ChangeCipherSpec denial-of-service";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of OpenSSL installed.


The OpenSSL toolkit implements SSLv2, SSLv3 and the TLSv1 protocols, and is
used by many applications.

There is a bug in the remote OpenSSL toolkit which may allow an attacker
to disable any SSL-related service remotely, by sending a carefully crafted
SSL/TLS handshake.


Solution : http://www.vuxml.org/freebsd/68233cba-7774-11d8-89ed-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of OpenSSL";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^openssl-0", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"openssl-0.9.7d") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
}

package = egrep(pattern:"^openssl-beta", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"openssl-beta-0.9.7d") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
}

package = get_kb_item("Host/FreeBSD/release");

if ( egrep(pattern:"FreeBSD-4\.[0-7]([^0-9]|$)", string:package) )
{
  security_hole(port);
  exit(0);
}

if ( egrep(pattern:"FreeBSD-4\.8", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.8_17") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.9", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.9_4") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-5\.[01]", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.1_16") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-5\.2", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.2.1_3") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

