#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12576);
 script_bugtraq_id(9667);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports : mnogosearch < 3.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of mnoGoSearch installed.

mnoGoSearch is a SQL-based hypertext search engine. There is a flaw in the
remote version of this software which may allow a remote user to execute
arbitrary code on this host.

To exploit this issue, an attacker would need to force this software to index
a maliciously crafted document, them making a request for that document.

Solution : http://www.vuxml.org/freebsd/87cc48fd-5fdd-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mnogosearch package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^mnogosearch-", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"mnogosearch-3.1.20_3") < 0 ) 
	security_hole(0);
