#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15805);
 script_bugtraq_id ( 11526 );
 script_cve_id ( "CAN-2004-0989" );
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : libxml < 1.8.17_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

libxml  < 1.8.17_3
libxml2 < 2.6.15

libxml contains multiple  buffer overflows in the URL parsing and DNS name 
resolving  functions. These vulnerabilities could lead to execution of  
arbitrary code.

Solution : http://www.vuxml.org/freebsd/9ff4c91e-328c-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libxml package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^libxml-[0-9]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"libxml-1.8.17_3") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^libxml2-[0-9]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"libxml2-2.6.15") < 0  )
	{
	security_hole(0);
	exit(0);
	}
