#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14216);
 script_bugtraq_id(10857);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0597","CAN-2004-0598","CAN-2004-0599");
 name["english"] = "FreeBSD libpng < 1.2.5_7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of libpng installed.

Libpng is a library used for manipulating graphics files.

Several buffer overflows have been discovered in libpng. An attacker
could create a carefully crafted PNG file in such a way that it would
cause an application linked with libpng to execute arbitrary code when
the file was opened by a victim.

See also : http://www.vuxml.org/freebsd/f9e3e60b-e650-11d8-9b0a-000347a4fa7d.html

Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libpng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^png-", string:pkgs);

if ( package && pkg_cmp(pkg:package, reference:"png-1.2.5_7") < 0 ) 
	security_hole(0);

