#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12532);
 script_bugtraq_id(6298);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2002-1580");
 name["english"] = "FreeBSD Ports : cyrus < 2.0.17";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the cyrus-imap package which
is older than 2.0.17.

Cyrus is an IMAP server. The remote version of this software has a pre-login
overflow condition which may allow an attacker to execute arbitrary code on
this host.

Solution : http://www.vuxml.org/freebsd/35f6fdf8-a425-11d8-9c6d-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cyrus package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^cyrus-imapd-2\.1", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"cyrus-imapd-2.1.11") < 0 )
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^cyrus-imapd-2\.0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"cyrus-imapd-2.0.17") < 0 )
	{
	security_hole(0);
	exit(0);
	}
