#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15524);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : a2ps-* < 4.13b_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	a2ps-a4       < 4.13b_2
	a2ps-letter   < 4.13b_2
	a2ps-letterdj < 4.13b_2

a2ps is an ASCII to PostScript command-line conversion tool.

The remote version of this software is vulnerable to a flaw in the way it
processes some of the command-line arguments, which may, under certain 
circumstances, allow an attacker to overwrite files he would otherwise
not have access to.

Solution : http://www.vuxml.org/freebsd/8091fcea-f35e-11d8-81b0-000347a4fa7d.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the a2ps-* package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

packages = egrep(pattern:"^a2ps-(a4|letter|letterd)-[0-4]", string:pkgs);
foreach package ( split(packages, sep:'\n', keep:0) )
{
if ( pkg_cmp(pkg:package, reference:"a2ps-a4-4.13b_2") < 0 )
	{
	security_note(0);
	exit(0);
	}
}
