/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.RankList;

public class DirectedGraph {
    public EdgeList spanningTree;
    private Insets defaultPadding = new Insets(16);
    public EdgeList edges = new EdgeList();
    public DirectedGraph gPrime;
    public NodeList nodes = new NodeList();
    public RankList ranks;

    public Insets getPadding(Node node) {
        Insets pad = node.getPadding();
        if (pad == null) {
            return this.defaultPadding;
        }
        return pad;
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
        edge.source.outgoing.remove(edge);
        edge.target.incoming.remove(edge);
        if (edge.vNodes != null) {
            int j = 0;
            while (j < edge.vNodes.size()) {
                this.removeNode(edge.vNodes.getNode(j));
                ++j;
            }
        }
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        if (this.ranks != null) {
            this.ranks.getRank(node.rank).remove(node);
        }
    }

    public void setDefaultPadding(Insets insets) {
        this.defaultPadding = insets;
    }
}

