/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ESequence.java,v 1.2 2004/05/06 20:23:43 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.ecore.util.FeatureMap;

import commonj.sdo.Sequence;

public interface ESequence extends Sequence
{
  FeatureMap featureMap();

  /**
   * Adds a new entry with the specified text value to the end of the entries.
   * @param text the value for the entry.
   */
  void add(String text);

  /**
   * Adds a new entry with the specified text value at the specified entry index.
   * @param index the index at which to add the entry.
   * @param text the value of the entry.
   */
  void add(int index, String text);
}
