### Name: setOldClass
### Title: Specify Names for Old-Style Classes
### Aliases: setOldClass .setOldIs POSIXct-class POSIXlt-class POSIXt-class
###   aov-class maov-class anova-class anova.glm-class anova.glm.null-class
###   data.frame-class density-class dump.frames-class factor-class
###   formula-class glm-class glm.null-class hsearch-class integrate-class
###   libraryIQR-class lm-class logLik-class mlm-class mtable-class
###   mts-class ordered-class packageIQR-class packageInfo-class
###   recordedplot-class rle-class socket-class summary.table-class
###   oldClass-class .OldClassesList table-class
### Keywords: programming methods

### ** Examples

setOldClass(c("mlm", "lm"))
setGeneric("dfResidual", function(model)standardGeneric("dfResidual"))
setMethod("dfResidual", "lm", function(model)model$df.residual)

## dfResidual will work on mlm objects as well as lm objects
myData <- data.frame(time = 1:10, y = (1:10)^.5)
myLm <- lm(cbind(y, y^3)  ~ time, myData)

## Don't show: 
stopifnot(identical(dfResidual(myLm), myLm$df.residual))
## End Don't show

rm(myData, myLm)
removeGeneric("dfResidual")



