#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12583);
 script_bugtraq_id(9976);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0381");
 name["english"] = "FreeBSD Ports : MySQL-client < 4.0.20";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the mysql-client package
installed.

The utility 'mysqlbug' which comes with this package creates 
temporary files insecurely. A local user may use this problem to
overwrite files he would otherwise not have access to.

Solution : http://www.vuxml.org/freebsd/2e129846-8fbb-11d8-8b29-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mysql-client package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^mysql-client-4\.0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mysql-client-4.0.20") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^mysql-client-4\.1", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mysql-client-4.1.1_2") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
package = egrep(pattern:"^mysql-client-5\.0", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"mysql-client-5.0.0_2") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
