#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# Ref: Debasis Mohanty
#
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14318);
 script_bugtraq_id(10948);
 script_version ("$Revision: 1.5 $");
 
 name["english"] = "CuteNews XSS";

 script_name(english:name["english"]);
 
 desc["english"] = "
CuteNews is installed on this remote host.

According to it's version number, this host is vulnerable to a 
cross-site-scripting (XSS) attack.  An attacker, exploiting this
flaw, would need to be able to coerce a user to browse to a purposefully
malicious URI.  Upon successful exploitation, the attacker would be able
to run code within the web-browser in the security context of the
CuteNews server.

Solution : Upgrade to CuteNews v1.3.2 or newer

Risk factor : Medium";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of show_archives.php";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 
 family["english"] = "CGI abuses";
  script_family(english:family["english"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))
	exit(0);
if(!can_host_php(port:port)) 
	exit(0);



function check(loc)
{
 	req = http_get(item:string(loc, "/show_archives.php?archive=<script>foo</script>&subaction=list-archive&"),
 		port:port);			
 	r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 	if( r == NULL )
		exit(0);
 	if(egrep(pattern:"<script>foo</script>", string:r))
 	{
 		security_warning(port);
		exit(0);
 	}
}


dir = make_list(cgi_dirs());
foreach d (dir)	
{
 	if(isnull(dirs))
		dirs = make_list(string(d, "/cutenews"));
 	else 
		dirs = make_list(dirs, string(d, "/cutenews"));
}

dirs = make_list(dirs, "", "/cutenews");



foreach dir (dirs)
{
 	check(loc:dir);
}
