#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14732);
 script_version("$Revision: 1.5 $");
 script_cve_id("CAN-2004-0573");
 script_bugtraq_id(11172);
 name["english"] = "Vulnerability in WordPerfect Converter (884933)";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Microsoft Office which contains
a flaw in its WordPerfect converter, which might allow an attacker to
execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to send a specially crafted file
to a user on the remote host and wait for him to open it using Microsoft Office.

When opening the malformed file, Microsoft Office will encounter a buffer
overflow which may be exploited to execute arbitrary code.


Solution : http://www.microsoft.com/technet/security/bulletin/ms04-027.mspx
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of MSCONV97.dll";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/WindowsVersion", "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");
if ( ! get_kb_item("SMB/WindowsVersion") ) exit(0);


rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion", item:"CommonFilesDir");

if(!rootfile)
{
 exit(0);
}


share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
dll =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\Microsoft Shared\TextConv\MSCONV97.dll", string:rootfile);




name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();
if(!port) port = 139;


if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);


if ( port == 139 )
{
r = smb_session_request(soc:soc, remote:name);
if(!r)exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot)exit(0);

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)exit(0);

uid = session_extract_uid(reply:r);



r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:dll);
if(fid)
{
 v = GetFileVersion(socket:soc, uid:uid, tid:tid, fid:fid);
 if ( ! v ) exit(0);
 z  = split(v, sep:".", keep:FALSE);
 if ( int(z[0]) < 2003 || ( int(z[0]) == 2003 && ( int(z[1]) < 1100 || (int(z[1]) == 1100 && int(z[2]) < 6252 )))) security_hole(port);
}
