#TRUSTED 0f3e01c16fbcf6056bef96232d545d3a545857130a34aa1bbecd29eb6cc2fa8dc51dec417827bf02153f999c5daff09957a1092b2cbe2ff44c010759e27bac363c33e58a7d82bc80cc060830292ceb591a45a560276405579fc5617125a4851c226415e0bdd5dec7823b173ce65cc5889a03aa049bad87fb5b9829c43f556fbc8ad6ea6c02ee51907a831cfe16f1a20ba48936943b27aaa257fd945656e3ffb584639aa3288cada7a7289c602b70b1e379f8f38c905580e0d3ba00550bc38db5fc1e5e7138f933dfbcdda4d7b5f34218c58ded80414766b0e86e627fdcaf49a1e47a7a803954868f3213ddcc8fb4f49d8aaa9f366955291e1a57e37be81101e9a7fca37d65720c061ceaeeca2baa149573b04b7cfed8fd982a065e5d0320b67f24554d4919ddacfeed46c461c50b37b203bc948aefe21404c806b267fa79d0e7dd69a2da4395fc27377b448ffa1e7721861da2edf2bb97052ade09531797fb0fdba2a2af31f4487ef2cae3d901f47cd9ab8fec35d1f7fe5a1feb0184eca991a236146d5e8b84ec46fc1d321fc03bb14de09e61a8813fd7532d4f2c82354b21913a9ed9570afecd6fd75bf4da9dcfb67e7cf758c1ae9e766594ec4d8d47da6c26ca1f5be6efa402cb0cef081cad32822b634dbf8ed42c9c5c53d332724958ff5746557c8e4cbd803289335ec8a4097d3e99b3694c3a8f81ef23b46ff77727fe53
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if ( ! defined_func("script_get_preference_file_location")) exit(0);
if ( ! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15887);
 script_version ("1.1");
 name["english"] = "Hydra: Socks5";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Socks5 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Socks5 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/socks5", 1080);
 script_dependencies("hydra_options.nasl", "find_service.nes", "socks.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/socks5");
if (! port) port = 1080;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "socks5";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/socks5/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the Socks5 server:\n' + report);
